---
title: Div Align Attribute
---
## Div Align Attribute

The `<div align="">` attribute is used for aligning the text in a div tag to the left, right, center or justify.

For instance:

```html
<html>
<head>
<title> Div Align Attribute </title>
</head>
<body>
<div align="left">
Lorem ipsum dolor sit amet, consectetur adipiscing elit, sed do eiusmod tempor incididunt ut labore et dolore magna aliqua.
</div>
<div align="right">
Lorem ipsum dolor sit amet, consectetur adipiscing elit, sed do eiusmod tempor incididunt ut labore et dolore magna aliqua.
</div>
<div align="center">
Lorem ipsum dolor sit amet, consectetur adipiscing elit, sed do eiusmod tempor incididunt ut labore et dolore magna aliqua.
</div>
<div align="justify">
Lorem ipsum dolor sit amet, consectetur adipiscing elit, sed do eiusmod tempor incididunt ut labore et dolore magna aliqua.
</div>
</body>
</html>
```
## Important!
This attribute is no longer supported in html5. CSS is the way to go.

The `<div align="">` attribute can be used to horizontally align the contents within a div. In the below example, the text will be centered within the div.

```html
<div align="center">
  This Text Will Be Centered
</div>
```

**This attribute is not supported in HTML5 and [CSS Text Align](https://github.com/freeCodeCamp/guides/blob/f50b7370be514b2a03ee707cd0f0febe2bb713ae/src/pages/css/text-align/index.md) should be used instead

