---
title: Font Color Attribute
---

## Font Color Attribute
This attribute is used to set a color to the text enclosed in a ```<font>``` tag.

### Syntax:
 ```html
<font color= "color">
 ```
 
### Important:
This attribute is not supported in HTML5. Instead, this [freeCodeCamp article](https://guide.freecodecamp.org/css/colors) specifies a CSS method, which can be used.

### Note:
A color can also be specified using a 'hex code' or an 'rgb code', instead of using a name.
 
### Example:
In this example we can see how to set green colour to the text enclosed in a `<font>`tag. There are three options:
1. Color name attribute
```html
<html>
  <body>
   <font color="green">Font color example using color name</font>
 </body>
</html>
```
2. Hex code attribute
```html
<html>
  <body>
   <font color="#00FF00">Font color example using hex code</font>
  </body>
</html>
```
3. RGB attribute
```html
<html>
  <body>
    <font color="rgb(0,255,0)">Font color example using RBG</font>
  </body>
</html>
```
4. HSL attribute
```html
<html>
  <body>
    <font color="hsl(80, 90%, 75%)">Font color example using color attribute</font>
  </body>
</html>
```
