---
title: Role Attribute
---
## Role Attribute

The `role` attribute describes the role of an element to programs that can make use of it, such as screen readers or magnifiers.

Usage Example: 
```html
<a href="#" role="button">Button Link</a>
```
Screen Readers will read this element as "button" instead of "link". 

There are four categories of roles: 
- Abstract Roles
- Widget Roles
- Document Structure Roles
- Landmark Roles

For the full list of existing roles, refer to [aria roles documentation](https://www.w3.org/TR/wai-aria/roles).
