---
title: HTML Editors
---

### HTML editors

An `HTML editor` is a program for editing `HTML` markup language. HTML editors can be created and modified HTML document.

However, for leraning HTML we recomended simple text editor like Notepad (Windows PC) or TextEdit (Mac).

* Simple text editor is good way to learn HTML for beginners.
* There are two main varieties of HTML editors: textual and WYSIWYG (what you see is what you get) editors.

### Text editor

Basic text editor is source code editors, include additional tools specifically geared toward handling code.


### WYSIWYG editors

HTML editors that support What You See Is What You Get (WYSIWYG) paradigm provide a user interface similar to a word processor for creating HTML documents, alternative to manual coding for editing HTML documents.


### Write HTML using Notepad or TextEdit

follow the below four steps to create your first web page with Notepad or TextEdit.
* * *

#### Step 1: Open Notepad (Windows PC) 

**Windows 8 or later:**

1. Open the **Start Screen** (the window symbol at the bottom left on your screen). 
   Type **Notepad**.

**Windows 7 or earlier:**

1. Open **Start > Programs > Accessories > Notepad**

#### Step 1: Open TextEdit (Mac) 

1. Open **Finder > Applications > TextEdit**

2. Also change some preferences to get the application to save files correctly. 
   In **Preferences > Format >** choose **"Plain Text"**

3. Then under "Open and Save", check the box that says "Display HTML files as HTML code      instead of formatted text".

4. Then open a new document to place the code.

#### Step 2: Write Some HTML

Write or copy some HTML into Notepad.

```HTML
<!DOCTYPE html>
<html>
<body>

<h1>My First Heading</h1>

<p>My first paragraph.</p>

</body>
</html>    
```

#### Step 3: Save the HTML Page

1. Save the file on your computer. Select **File > Save** as in the Notepad menu.

2. Name the file **"index.html"** and set the encoding to **UTF-8** 
   (which is the preferred encoding for HTML files).

>  You can use either .htm or .html as file extension. There is no difference, it is up 
>  to you.

#### Step 4: View the HTML Page in Your Browser

Open the saved HTML file in your favorite browser (double click on the file, or right-click - and choose "Open with").

### List of Editors (Open-source and Commercial softwares)

* [Eclipse](https://www.eclipse.org)
* [Atom](https://atom.io)
* [WebStorm](https://www.jetbrains.com)
* [Microsoft Visual Studio](https://visualstudio.microsoft.com/)
* [NetBeans](http://netbeans.apache.org/)
* [Brackets](http://brackets.io)
* [EditPlus](https://editplus.com/)
* [Sublimetext](https://www.sublimetext.com)

#### More Information:

<a href='https://en.wikipedia.org/wiki/HTML_editor' target='_blank' rel='nofollow'>Wikipedia HTML editors<table> tag</a>
<a href='https://www.w3schools.com/html/html_editors.asp' target='_blank' rel='nofollow'>W3schools HTML Editors<table> tag</a>

