---
title: Div Tag
---
## Div Tag

The `<div>` tag is a generic container that defines a section in your HTML document. A `<div>` element is used to group sections of HTML elements together and format them with CSS. A `<div>` is a block-level element. This means that it takes up its own line on the screen. Elements right after the `<div>` will be pushed down to the line below. For similar grouping and styling that is not block-level, but inline, you would use the `<span>` tag instead. The <span> tag is used to group inline-elements in a document.

### Example
Here is an example of how to display a section in the same color:

```html
<div style="color:#ff0000">
  <h3>my heading</h3>
  <p>my paragraph</p>
</div>
```

#### Differences between `<span>` and `<div>`
The main difference is that `<span>` is an inline element, while `<div>` is a block element. This means that a `<span>` can appear within a sentence or paragraph (as in the example above), while a `<div>` will start a new line of content. Note that the CSS `display` property can change this default behavior, but that's way beyond the scope of this article!

##### More Information:
<a href='https://www.tutorialspoint.com/html/html_div_tag.htm' target='_blank' rel='nofollow'>Tutorialspoint</a>

<a href='https://developer.mozilla.org/en-US/docs/Web/HTML/Element/div' target='_blank' rel='nofollow'>MDN</a>


