---
title: Doctype Tag
---
## Doctype Tag

HTML code is always accompanied by its "boilerplate" of tags. The very first tag found on any HTML file must be a Doctype declaration.
The html5 doctype `<!DOCTYPE html>` is a required preamble used to inform the browser which [rendering mode](https://developer.mozilla.org/en-US/docs/Quirks_Mode_and_Standards_Mode) to use (HTML5 vs. XHTML). Be sure to place the doctype at the very top of the document.

```html
<!DOCTYPE html>
<html>
    <head>
        <meta charset=UTF-8>
        <title>Document Title</title>
    </head>
    <body>
        <p>Document content.</p>
    </body>
</html>
```

#### More Information:

- [Doctype: MDN](https://developer.mozilla.org/en-US/docs/Glossary/Doctype)
- [Introduction to HTML5: MDN](https://developer.mozilla.org/en-US/docs/Web/Guide/HTML/HTML5/Introduction_to_HTML5)
- [Quirks Mode and Standards Mode: MDN](https://developer.mozilla.org/en-US/docs/Quirks_Mode_and_Standards_Mode)
