---
title: Label Tag
---

# Label Tag
<***label***> defines a label for an `<input>` type element/tag.

### Usage
```
<label for="id">Label</label>
<input type="text" name="text" id="id" value="yourvalue"><br>
```
As you can see, the *for* attribute of the `<label>` tag should be equal to the id attribute of the related element to bind them together.

### Platform Support
|Browser|Element Support|
|:-----:|:-------------:|
|Internet Explorer|Yes|
|Mozilla Firefox|Yes|
|Google Chrome|Yes|
|Opera|Yes|
|Safari|Yes|

### Attributes
|Attribute|	Value|Description|
|:-------:|:----:|:---------:|
|for|	element_id|	Specifies which form element a label is bound to|
|form|form_id	|Specifies one or more forms the label belongs to|


### Global Attribute
The <**label**> tag supports the Global Attributes in HTML.

### Event Attribute
The <**label**> tag supports the Event Attributes in HTML.

> The <**label**> element does not render as anything special for the user. However, it provides a usability improvement for mouse users, because if the user clicks on the text within the <label> element, it toggles the control.

#### More Information:
[MDN - Label Tag](https://developer.mozilla.org/en-US/docs/Web/HTML/Element/label)  
[W3School - Label Tag](https://www.w3schools.com/tags/tag_label.asp)
