---
title: Lists
---
## Lists

There are three types of lists in HTML. All lists must contain one or more list elements.

### Unordered HTML List
The unordered list starts with `<ul>` tag and list items start with the `<li>` tag. In unordered lists all the list items marked with bullets by default.
  
  ```
  <ul>
    <li>Item</li>
    <li>Item</li>
    <li>Item</li>
  </ul>
  ```
  Output:
  <html>
    <ul>
    <li>Item</li>
    <li>Item</li>
    <li>Item</li>
  </ul>
  </html>

### Ordered HTML List
The ordered list starts with `<ol>` tag and list items start with the `<li>` tag. In ordered lists all the list items are marked with numbers.

  ```
  <ol>
    <li>First Item</li>
    <li>Second Item</li>
    <li>Third Item</li>
  </ol>
  ```
  Output:
   <html>
   <ol>
    <li>First Item</li>
    <li>Second Item</li>
    <li>Third Item</li>
  </ol>
</html>

### HTML Description List
The description list contains list items with their definitons. We use `<dl>` tag to start list, `<dt>` tag to define a term and `<dd>` tag to describe each term.

 ```
 <dl>
 <dt>freeCodeCamp</dt>
 <dd>Learn to code with free online courses, programming projects, and interview preparation for developer jobs.</dd>
 <dt>GitHub</dt>
 <dd>GitHub is a web-based Git or version control repository and Internet hosting service. It is mostly used for code.</dd>
 </dl>
 ```
 Output:
 <html>
   <dl>
 <dt>freeCodeCamp</dt>
 <dd>Learn to code with free online courses, programming projects, and interview preparation for developer jobs.</dd>
 <dt>GitHub</dt>
 <dd>GitHub is a web-based Git or version control repository and Internet hosting service. It is mostly used for code.</dd>
 </dl>
  </hhtml>

#### More Information:
<a href='https://html.com/lists/' target='_blank' rel='nofollow'>HTML</a>

<a href='https://www.w3schools.com/html/html_lists.asp' target='_blank' rel='nofollow'>w3schools</a>


