---
title: Main Tag
---
## Main Tag

The `<main>` tag works similar to the `<div>` tag but semantically represents the main content of the document or portion of the document. Multiple `<main>` tags may be used, e.g. for the main content of various articles, and thus its contents should be unique to the document and not repeated elsewhere.

### Example
The following example illustrates the use of the `<main>` tag:

```html
<!-- other content -->

<main>
  <h1>Diary Entry 31</h1>
  <p>Oct 23 2017</p>
  
  <article>
    <h2>Today Is Unique</h2>
    <p>This information will be unique among other articles.</p>
  </article>
</main>

<!-- other content -->
```
