---
title: Section Tag
---
## Section

The HTML ```<section>``` element defines a section within an HTML page that is used when there is not a more specific semantic HTML element to represent it. Typically, a ```<section>``` element will include a heading element (```<h1>``` - ```<h6>```) as child element.

For example, a web page could be divided into various sections such as welcome, content and contact sections.

A ```<section>``` element should not be used in place of a ```<div>``` element if a generic container is needed. It should be used to define sections within an HTML page.

```html
<html>
<head>
  <title>Section Example</title>
</head>
<body>
  <section>
    <h1>Heading</h1>
    <p>Bunch of awesome content</p>
  </section>
</body>
</html>
```

#### More Information:
* [MDN Web Docs](https://developer.mozilla.org/en-US/docs/Web/HTML/Element/section)
* [W3 Schools](https://www.w3schools.com/tags/tag_section.asp)
