---
title: JavaScript Tutorials and Other Resources
---

*   <a href="https://javascript30.com/" target='_blank' rel='nofollow'>Wes Bos's 30 Days of JavaScript</a>
*   <a href='http://jsforcats.com/' target='_blank' rel='nofollow'>JavaScript for Cats</a>
*   <a href='https://javascript.info/' target='_blank' rel='nofollow'>The Modern JavaScript Tutorial</a>
*   <a href='https://github.com/DrBoolean/mostly-adequate-guide' target='_blank' rel='nofollow'>Professor Frisby's Mostly Adequate Guide to Functional Programming</a>
*   <a href='http://www.eloquentjavascript.net' target='_blank' rel='nofollow'>Eloquent JavaScript</a> (<a href='https://watchandcode.com/courses/eloquent-javascript-the-annotated-version' target='_blank' rel='nofollow'>_annotated_</a>)
*   <a href='http://speakingjs.com/es5/' target='_blank' rel='nofollow'>Speaking JavaScript</a>
*   <a href='http://exploringjs.com/es6/' target='_blank' rel='nofollow'>Exploring ES6</a>
*   <a href='https://www.youtube.com/watch?v=Bv_5Zv5c-Ts' target='_blank' rel='nofollow'>Udemy - JavaScript Understanding the Weird Parts (_first 3.5 hrs_)</a>
*   <a href="https://www.youtube.com/playlist?list=PL0zVEGEvSaeEd9hlmCXrk5yUyqUag-n84">Functional programming in JavaScript</a>
*   <a href='https://www.educative.io/collection/5679346740101120/5720605454237696?authorName=Arnav%20Aggarwal' target='_blank' rel='nofollow'>Introduction to JavaScript: First Steps</a>
*   <a href='https://www.youtube.com/watch?v=v2ifWcnQs6M&index=1&list=PL62E185BB8577B63D' target='_blank' rel='nofollow'>Douglas Crockford's Videos</a>
*   <a href='https://mbeaudru.github.io/modern-js-cheatsheet/' target='_blank' rel='nofollow'>Modern JS Cheatsheet</a>
*   <a href='http://www.codeconquest.com/blog/top-50-websites-to-learn-javascript/' target='_blank' rel='nofollow'>The 50 Best Websites to Learn JavaScript</a>
*   <a href='https://www.codementor.io/community/topic/javascript' target='_blank' rel='nofollow'>Codementor JavaScript tutorial</a> 
*   <a href='http://youmightnotneedjquery.com/' target='_blank' rel='nofollow'>You Might Not Need jQuery</a>
*   <a href='http://www.theodinproject.com/' target='_blank' rel='nofollow'>The Odin Project</a>
*   <a href='https://learnxinyminutes.com/docs/javascript/' target='_blank' rel='nofollow'>Learn X in Y minutes (X = JavaScript)</a>
*   <a href='http://javascriptbook.com/' target='_blank' rel='nofollow'>JavaScript and jQuery: interactive front-end web development</a>



## References

*   [Mozilla Developer Network (MDN)](https://developer.mozilla.org/en-US/docs/Web/JavaScript)
*   [DevDocs](https://devdocs.io/javascript)
*   [OverAPI JavaScript Cheat Sheet](http://overapi.com/javascript)
*   [ECMA-262 (2018)](https://www.ecma-international.org/publications/standards/Ecma-262.htm)
*   [JavaScript Libraries](http://jster.net)
*   [You Might Not Need jQuery](http://youmightnotneedjquery.com)
*   [Use JSDoc](http://usejsdoc.org)


## Tutorials

*   [Codecademy](https://www.codecademy.com/catalog/language/javascript)
*   [RithmSchool](https://www.rithmschool.com/courses)
*   [The Modern JavaScript Tutorial](https://javascript.info/)
*   [Introduction to JavaScript: First Steps](https://www.educative.io/collection/5679346740101120/5720605454237696)
*   [JavaScript for Cats](http://jsforcats.com/)
*   [JavaScript.com by Pluralsight](https://www.javascript.com/learn)
*   [SoloLearn JavaScript Tutorial](https://www.sololearn.com/Course/JavaScript/)
*   [GeeksforGeeks](https://www.geeksforgeeks.org/javascript-tutorial/)
*   [Udacity Intro to JavaScript](https://eu.udacity.com/course/intro-to-javascript--ud803)
*   [Tutorial to React](https://reactjs.org/tutorial/tutorial.html)
*   [Introduction to Babel](https://flaviocopes.com/babel/)
*   [Khan Academy - Intro to JS](https://www.khanacademy.org/computing/computer-programming/programming)

## Video Tutorials

*   [Derek Banas - Learn JS In One Video](https://www.youtube.com/watch?v=fju9ii8YsGs)
*   [Derek Banas - Object Oriented JavaScript](https://www.youtube.com/watch?v=O8wwnhdkPE4)
*   [JavaScript Fundamentals for Absolute Beginners 2018](https://www.youtube.com/watch?v=YMvzfQSI6pQ)
*   [Udemy - JavaScript Understanding the Weird Parts (_first 3.5 hrs_)](https://www.youtube.com/watch?v=Bv_5Zv5c-Ts)
*   [Functional programming in JavaScript](https://www.youtube.com/playlist?list=PL0zVEGEvSaeEd9hlmCXrk5yUyqUag-n84)
*   [Douglas Crockford's Videos](https://www.youtube.com/watch?v=v2ifWcnQs6M&index=1&list=PL62E185BB8577B63D)
*   [Gordon Zhu - Practical JavaScript](https://watchandcode.com/p/practical-javascript)
*   [The Net Ninja - JavaScript Tutorial for Beginners](https://www.youtube.com/watch?v=qoSksQ4s_hg&list=PL4cUxeGkcC9i9Ae2D9Ee1RvylH38dKuET)


## Desktop Editors


 *   [Visual Studio Code](https://code.visualstudio.com)
    
    Visual Studio Code includes built-in support for IntelliSense code completion, rich semantic code understanding and navigation, and code refactoring. It comes with a built-in debugger and git support and has a plethora of extensions.
    
    <a href='https://code.visualstudio.com/insiders/' target='_blank' rel='nofollow'>Visual Studio Code Insiders</a>
    
    Insiders has the most recent code pushes and may lead to the occasional broken build. New builds at least everyday with features, bug fixes, and other recently closed issues. Insiders installs next to the Stable build, allowing you to use either independently.


*   [WebStorm](https://www.jetbrains.com/webstorm)

    A full-feature IDE for JavaScript, including code completion and support for live linting, version control, and testing. Made by JetBrains and modelled after their IntelliJ Java IDE.

*   <a href='http://brackets.io' target='_blank' rel='nofollow'>Brackets</a>

    A text editor made with web designers and front-end developers in mind. Features include: inline editing, live preview, and preprocessor support.   
    
*   <a href='http://atom.io' target='_blank' rel='nofollow'>Atom</a>

    Atom is an open source text editor made by GitHub. It features embedded Git Control and numerous customization options.
    
*   [Brackets](http://brackets.io)

    Lightweight text editor featuring inline editors, live previews, and allows you to quick edit and live highlight with your LESS and SCSS files.

*   [Sublime Text](https://www.sublimetext.com)
    Sublime Text is a cross-platform editor featuring a Python API. Free to download and evaluate, but requires a license for continued use.

    A cross-platform editor with a Python API. It features many shortcuts, key bindings and visual customization.
  
## Online Editors

*   [REPL](https://repl.it) - Great for working with Node.js
*   [JSBin](https://jsbin.com)
*   [JSFiddle](https://jsfiddle.net)
*   [CodePen](https://codepen.io)
*   [CoderPad](https://coderpad.io) - Great for Pair Programming
*   [Object Playground](http://www.objectplayground.com) - Excellent resource to get to grips with Object Orientated JS.
*   [Plunker](https://plnkr.co)
*   [AWS Cloud 9](https://aws.amazon.com/cloud9) - Cloud Based IDE by Amazon
*   [Glitch](https://glitch.com/)
*   [Babel](https://babeljs.io/repl) - An easy way to see how Babel will convert your ECMAScript 2015+ code into a backwards compatible version of JS.


## Coding Challenges and Exercises

*   [Code Wars](https://www.codewars.com)
*   [Hacker Rank](https://hackerrank.com)
*   [Coding Game](https://codingame.com)
*   [CodeSignal](https://codesignal.com)
*   [ES6 Katas](http://es6katas.org)
*   [Project Euler](https://projecteuler.net)
*   [Codility](https://codility.com/programmers/lessons)
*   [Coderbyte](https://coderbyte.com)
*   [Exercism](https://exercism.io)
*   [JavaScript30](https://javascript30.com)

## Interview Preparation

*   <a href="https://medium.freecodecamp.org/5-top-sites-for-javascript-interview-preparation-71b48e9a6c8a">Interview Preparation Resources</a>

## Blogs

*   [JavaScript on Medium](https://medium.com/topic/javascript)
*   [The Cost Of JavaScript In 2018](https://medium.com/@addyosmani/the-cost-of-javascript-in-2018-7d8950fbb5d4)
*   [Codementor JavaScript Tutorials and Insights](https://www.codementor.io/community/topic/javascript)
*   [2ality](https://www.2ality.com)
*   [David Walsh](https://davidwalsh.name)
*   [SuperheroJS](http://superherojs.com)
*   [The 50 Best Websites to Learn JavaScript](http://www.codeconquest.com/blog/top-50-websites-to-learn-javascript/)
*   [Perfection Kills](http://perfectionkills.com) - Not been updated since 2015
*   [Top mentioned Javascript books of Reddit, Hacker News and Stack Overflow](https://medium.com/@jadeydi/best-javascript-books-should-be-read-which-are-recommended-by-hundreds-people-eeb87353f10d)


## Podcasts

*   [JavaScript Jabber](https://devchat.tv/js-jabber)
*   [Syntax FM](https://syntax.fm/)
*   [Fulstack Radio](http://www.fullstackradio.com//)


## Free JavaScript Books

*   [You Don't Know JS](https://github.com/getify/You-Dont-Know-JS)
    
    6 books on JavaScript by Kyle Simpson. From beginner to advanced. 
    
*   [Eloquent JavaScript](https://eloquentjavascript.net/)  

    Fantastic, thorough introduction to the basics and features of JavaScript, complete with in-browser interactive code
    
*   [Professor Frisby's Mostly Adequate Guide to Functional Programming](https://github.com/DrBoolean/mostly-adequate-guide)  

    Quite in-depth guide to Functional Programming in JavaScript
    
*   [Functional Light JS](https://github.com/getify/Functional-Light-JS)

    This book aims to be a useful companion for anyone wishing to (re)discover the many facets of JavaScript. From the very basics of programming up to front-end and back-end web development.  Many topics are covered in a simple and accessible way. No prior knowledge needed!

*   [Learning JavaScript Design Patterns](http://addyosmani.com/resources/essentialjsdesignpatterns/book)
*   [Airbnb JavaScript Style Guide](https://github.com/airbnb/javascript)
*   [JavaScript Allonge Six](https://leanpub.com/javascriptallongesix/read)
*   [The JavaScript Way](https://github.com/bpesquet/thejsway)
*   [Modern JS Cheatsheet](https://mbeaudru.github.io/modern-js-cheatsheet)
*   [Speaking JavaScript](http://speakingjs.com/es5)
*   [Exploring ES6](http://exploringjs.com/es6)
