---
title: Code Linting
---

Linting is the process of running a program that analyzes your code for programmatic and stylistic errors. A linting tool, or a linter, marks or flags any potential errors in your code such as syntax errors or incorrectly spelled variable names. This can save time and help you write better code.

Linters will go through your code, and highlight

-  formatting discrepancy 
-  non-adherence to coding standards and conventions 
-  pinpointing possible logical errors in your program
 
 Running a linter on your code makes sure it follows best practices, is readable and easy to maintain.

Linters can be installed using `npm` or another package manager. Linters can be used from the command line by passing in files. Linters are also available as plugins for tools and sometimes they are directly integrated into editors.

Here are some popular JavaScript Linters:

[JSLint](http://www.javascriptlint.com/online_lint.php) 

[JSHint](http://jshint.com) 

[JSCS](http://jscs.info) 

[ESLint](http://eslint.org)

#### Linters for Editors :
* Visual Code : To Install the eslint extension, open command palette (View -> Command Palette.. or cmd+shift+p ) and execute command:
ext install eslint

#### Tools and Plugins
[Prettier](https://prettier.io)
