---
title: Naming Convention for JavaScript
---
Here you will get an overview of the different code cases that are widely used.

## camelCase

In programming, camelCase formatting for variable names looks like this:

    var camelCase = "lower-case first word, capitalize each subsequent word";

## PascalCase

PascalCase (or CamelCase) is a variant of camelCase. It differs from camelCase by capitalizing every word, *including* the first word:

    var PascalCase = "upper-case every word";

## snake_case

Another popular case called snake_case separates each word with underscores in this manner:

    var snake_case = "lower-case everything, but separate words with underscores";
