---
title: Random Method
---
## Random Method
The JavaScript `Math.random()` method is an excellent built-in method for producing random numbers. When `Math.random()` is executed, it returns a random number that can be anywhere between 0 and 1. The 0 is included and 1 is excluded.

### Generating a random floating point number between 0 and 1
The `Math.random()` method will return a floating point (decimal) number greater than or equal to 0 and less than (but never equal to) 1. In other words `0 <= x < 1`. For example:

```JavaScript
console.log(Math.random());
// 0.7069207248635578

console.log(Math.random());
// 0.765046694794209

console.log(Math.random());
// 0.14069121642698246
```

(Of course, the numbers returned will be different every time. This will be assumed for all following examples - different results will happen on each pass.)

To get a random number between a larger range multiply the result of `Math.random()` by a number.

### Generating a random floating point number between 0 and a specified max
Usually you do not need random numbers between 0 and 1 - you need larger numbers or even integers.

For example, if you want a random floating point number between 0 and 10, you could use:

```JavaScript
var x = Math.random()*10;

console.log(x);
// 4.133793901445541

//In function form
function randomFloatZeroToMax(max){
  return Math.random()*max;
}
```

### Generating a random floating point number within a range
If you need a random floating point number that ranges between two specific numbers, you could do something like this:

```JavaScript
var min = 83.1;
var max = 193.36;

var x = Math.random()*(max - min)+min;

console.log(x);
// 126.94014012699063

//In function form
function randomFloatInRange(min, max){
  return Math.random()*(max - min)+min;
}
```

### Generating a random integer between 0 and a max
Often you need integers. To do this you will have to use some other methods from the `Math` object, `Math.floor()` (rounds down to the nearest integer) and `Math.ceil()` (rounds up to the nearest integer).

For example, if you need to select randomly from an array of 10 elements, you would need a random number between 0 and 9 inclusive (remember that arrays are zero indexed).

```JavaScript
var x = Math.floor(Math.random()*10);

console.log(x);
// 7

//In function form
function randomIntZeroToMax(max){
  return Math.floor(Math.random()*max);
}
```

(Remember that `Math.random()` will never return exactly 1, so `Math.random()*10` will never return exactly 10. This means that after rounding down, the result will always be 9 or less.)

### Generating a random integer between 1 and a max
If you need a random number with the minimum number being 1 (for example picking a random day in January) you could use the `Math.ceil()` method.

```JavaScript
var x = Math.ceil(Math.random()*31);

console.log(x);
// 23

//In function form
function randomIntOneToMax(max){
  return Math.ceil(Math.random()*max);
}
```

Another way would have been to use the previous function (using `Math.floor()`) and add 1 to it:

```JavaScript
var x = Math.floor(Math.random()*31)+1;

console.log(x);
// 17

//In function form
function randomIntInRange(min, max){
  return Math.floor(Math.random()*(max-1))+1;
}
```

### Generating a random integer within a range
Lastly, occasionally you need a random integer between two specific integers. For example, if you are trying to pick raffle tickets and you know the numbers of the lowest and largest number:

```JavaScript
var min = 1718;
var max = 3429;

var x = Math.floor(Math.random()*(max-min+1)+min);

console.log(x);
//2509

//In function form
function randomIntInRange(min, max){
  return Math.floor(Math.random()*(max - min)+min);
}
```

### How random is Math.random()?
It may be pointed out that the number returned by `Math.random()` is a pseudo-random number as no computer can generate a truly random number, that exhibits randomness over all scales and over all sizes of data sets. However, the pseudo-random number generated by `Math.random()` is usually sufficient for the needs of nearly any program you may write. The not-truly-randomness only becomes apparent in astronomically large number sets or when uncommonly precise decimals are needed.

### More Information:
- Documentation: <a href='https://developer.mozilla.org/en-US/docs/Web/JavaScript/Reference/Global_Objects/Math/random' target='_blank' rel='nofollow'>MDN</a>
