---
title: Math Floor
---
## Math Floor

`Math.floor()` is a method of the Math standard object that rounds a given number downwards to the next integer. Take note that for negative numbers this means that the number will get rounded "away from 0" instead of to the number of smaller absolute value since `Math.floor()` returns the largest integer less than or equal to the given number.

### Examples
```javascript
Math.floor(0.9)  //  0
Math.floor(1.3)  //  1
Math.floor(0.5)  //  0
Math.floor(-0.9) // -1
Math.floor(-1.3) // -2
```

### More Information:
* [MDN](https://developer.mozilla.org/en-US/docs/Web/JavaScript/Reference/Global_Objects/Math/floor)
* [w3schools](https://www.w3schools.com/jsref/jsref_floor.asp)
* [Wikipedia](https://en.wikipedia.org/wiki/Floor_and_ceiling_functions)
