---
title: Math Pow
---
## Math Pow

`Math.pow()` returns the value of a number to the power of another number. 

#### Syntax

`Math.pow(base, exponent)`, where `base` is the base number and `exponent` is the number by which to raise the `base`.

`pow()` is a static method of `Math`, therefore it is always called as `Math.pow()` rather than as a method on another object.

#### Examples

```js
Math.pow(5, 2); // 25
Math.pow(7, 4); // 2401
Math.pow(9, 0.5); // 3
Math.pow(-8, 2); // 64
Math.pow(-4, 3); // -64
```

#### More Information:
<a href="https://developer.mozilla.org/en-US/docs/Web/JavaScript/Reference/Global_Objects/Math/pow" target="_blank" rel="nofollow">MDN</a>


