---
title: Math Sqrt
---
## Math Sqrt

The function `Math.sqrt()` returns the square root of a number. 

If a negative number is entered, `NaN` is returned.

`sqrt()` is a static method of `Math`, therefore it is always called as `Math.sqrt()` rather than as a method on another object. 

#### Syntax

`Math.sqrt(x)`, where `x` is a number. 

#### Examples

```js
Math.sqrt(25); // 5
Math.sqrt(169); // 13
Math.sqrt(3); // 1.732050807568
Math.sqrt(1); // 1
Math.sqrt(-5); // NaN
```

#### More Information:
<a href="https://developer.mozilla.org/en-US/docs/Web/JavaScript/Reference/Global_Objects/Math/sqrt" target="_blank" rel="nofollow">MDN</a>


