---
title: Comment Your JavaScript Code
---
Comments are a great way to leave notes to yourself and to other people who will later need to figure out what it does. Any code in it will be ignored.

Let's take a look at the two ways you can write comments in JavaScript.

*   The double-slash comment will comment out the remainder of the text on the current line:

`// This is a single line comment.`

*   The slash-star-star-slash comment will comment out everything between the `/*` and the `*/` characters:

```javascript
/* 
This is 
a multi-line comment 
(comment block) 
*/
```

Comments are a great thing and are extremely valuable when used properly. As a professional developer, you'll often spend more time reading and working through other peoples code than writing your own. However, take care not to fall into the trap of over-commenting. The languages we use, like JavaScript, were created to be human readable. Take care not litter your code with unhelpful comments that simply restate what the code is doing. Instead, strive to write code that is self-documenting and leave comments explaining business logic, weird edge cases, etc.
