---
title: Advantages of Linux
---
## Constant and efficient improvements.

Linux updates happen through the global collaboration of developers. Bugs are documented and resolved much quicker with this type of support. Also, since the developers are also the end-users they have the proper motivation to make sure it meets user's needs and that it is designed to run well.

## Open Source.
All of the code that makes any Linux distribution work is freely available for anyone to review. This gives an added layer of transparency and guarantees that it would be difficult for someone to commit code with malicious purposes. This allows for constant code review by experienced programmers and developers to ensure the best available experience for the user as the operating system is continuously refined.

## Less risk.

Software is only as good as the support it's given. Imagine this: a piece of software is created by the company XYZ and later down the road, they go bankrupt or get bought by another company that decides to cut its support. The software would never see improvements or fixes and therefore its usefulness would inevitably erode and die. Linux is owned and operated by no single entity or company, so this situation cannot happen. More than that anyone is free to pick it up and contribute as well. The risk of losing support for Linux is very unlikely due to its overwhelming popularity and use.

## Lightweight.

Linux's requirements for running on a system are much lower than that of Windows or Mac. The right Linux distribution can allow a modest setup and Linux will give the system value. Disk space and memory footprint can also be lower too. Some distributions are suitable for CPUs dating back to the Pentium family, others have a requirement of as little as 128MB of RAM and around the same amount for disk space!

## Variety.

With a vast number of linux distributions, you may very well find yourself having a favorite distro for every day of the week. No matter what you plan on using your machine for, there is a linux distro that has it covered. Want security? No problem, Tails OS has you covered (https://tails.boum.org/). Want something lightweight that you can run on your old Chromebook? Gallium OS has you covered. (https://galliumos.org/)

The linux community is super active, and there are always new distros being released. Look around, and find something that will benefit you! Don't let the idea of linux scare you, try it out!

## Heavily documented for beginners and advanced users alike.

Linux has an active community of those willing to share their knowledge and help (much like FreeCodeCamp!). There are command line utilities built into Linux that provide documentation on commands, libraries, standards, etc. (<a href='https://en.wikipedia.org/wiki/Man_page' target='_blank' rel='nofollow'>Man pages</a> and <a href='https://en.wikipedia.org/wiki/Info_(Unix' target='_blank' rel='nofollow'>Info pages</a>), and there is documentation available on the Internet in a variety of formats including <a href='http://www.tldp.org/' target='_blank' rel='nofollow'>The Linux Documentation Project</a>, <a href='http://www.linuxquestions.org/' target='_blank' rel='nofollow'>LinuxQuestions</a>, <a href='http://serverfault.com/' target='_blank' rel='nofollow'>ServerFault</a>, and <a href='https://wiki.archlinux.org/' target='_blank' rel='nofollow'>The Arch Wiki</a>. 

In addition to documentation, there are plenty of helpful and welcoming communities for newcomers to ask questions such as <a href='https://askubuntu.com/' target='_blank' rel='nofollow'>Ask Ubuntu</a> and <a href='https://www.reddit.com/r/linuxquestions/' target='_blank' rel='nofollow'> Reddit's r/linuxquestions</a>.

There are self-paced certifications that can be taken that are recognized in the IT industry (<a href='https://certification.comptia.org/certifications/linux' target='_blank' rel='nofollow'>CompTIA's Linux+</a> and <a href='https://www.lpi.org' target='_blank' rel='nofollow'>LPI's LPIC tests</a>). Although not required, learning <a href='https://en.wikipedia.org/wiki/C_(programming_language)' target='_blank' rel='nofollow'>C</a> gives the ability for a user to review the Linux code to see what they are running.

## Business support.

The world depends on Linux supporting critical systems so the demand is not going away. This is important not only to those that help contribute to Linux, but also to those who support it (Jobs!). Linux support becomes more critical in IT, but also having that knowledge as a developer will make them more rounded and useful (i.e. <a href='https://medium.com/chris-messina/the-full-stack-employee-ed0db089f0a1#.ubttrv255' target='_blank' rel='nofollow'>Full stack developers</a>).

## Interoperability with other Operating Systems.

Linux has driver support for NTFS and HFS+ filesystems (used by Windows and Macs) and also <a href='https://www.samba.org/' target='_blank' rel='nofollow'>Samba</a> for file/print service support on Windows machines.

## Better hardware support.

For other OSs, usually a user would have to go to the manufacturer's website to get driver support for different types of hardware. The Linux kernel supports a majority of hardware automatically via plug-and-play (largely in part because of the open source community). Some manufacturers also develop Linux versions of their proprietary drivers which could be easily installed via the software repository of a distribution or by manually installing the provided binaries.

## Software Availability/Compatibility.

Linux has a rich set of applications that are available. It has <a href='https://www.libreoffice.org/discover/libreoffice/' target='_blank' rel='nofollow'>office applications</a>, web browsers (<a href='https://www.google.com/chrome/browser/desktop/' target='_blank' rel='nofollow'>Google Chrome</a> and <a href='https://www.mozilla.org/en-US/firefox/new/' target='_blank' rel='nofollow'>Mozilla Firefox</a>), <a href='http://www.videolan.org/vlc/' target='_blank' rel='nofollow'>media players</a>, <a href='https://www.gimp.org/' target='_blank' rel='nofollow'>image</a>/<a href='http://www.openshot.org/' target='_blank' rel='nofollow'>video processing</a>, etc. For video gaming, <a href='http://store.steampowered.com/about/' target='_blank' rel='nofollow'>Steam</a> runs on Linux which has many supported games. Windows applications can also run within Linux (see <a href='https://www.winehq.org/' target='_blank' rel='nofollow'>Wine</a> for details).

## Built for development.

As Linux was originally made for developers by developers, they have spent much time and effort perfecting the tools that they would come to use. It has a powerful <a href='https://en.wikipedia.org/wiki/Unix_shell' target='_blank' rel='nofollow'>shell</a> that can be used for a variety of both programming and administrative tasks (<a href='https://en.wikipedia.org/wiki/Bash_(Unix_shell' target='_blank' rel='nofollow'>Bash</a>) is the most popular and default choice for Linux). While Linux has a "notepad" equivalent in <a href='https://en.wikipedia.org/wiki/Gedit' target='_blank' rel='nofollow'>gedit</a>, it also provides more powerful and customizable text-based editors such as <a href='https://en.wikipedia.org/wiki/Vim_(text_editor)' target='_blank' rel='nofollow'>Vim</a>) and <a href='https://en.wikipedia.org/wiki/Emacs' target='_blank' rel='nofollow'>Emacs</a> (It is recommended Linux users know at least one of these editors). There are also IDEs available for web-development such as <a href='https://atom.io/' target='_blank' rel='nofollow'>Atom</a>, <a href='http://www.aptana.com/' target='_blank' rel='nofollow'>Aptana</a>/<a href='https://eclipse.org/' target='_blank' rel='nofollow'>Eclipse</a>, <a href='https://www.sublimetext.com/' target='_blank' rel='nofollow'>Sublime</a>, <a href='http://komodoide.com/' target='_blank' rel='nofollow'>KomodoIDE</a>, to name a few. Linux also can utilize software such as <a href='https://httpd.apache.org/' target='_blank' rel='nofollow'>Apache</a> to setup a local web server for testing, <a href='https://git-scm.com/' target='_blank' rel='nofollow'>Git</a> for version control, and other tools/languages such as <a href='https://nodejs.org/en/' target='_blank' rel='nofollow'>Node.js</a>/<a href='https://www.ruby-lang.org/en/' target='_blank' rel='nofollow'>Ruby</a>/<a href='http://sass-lang.com/' target='_blank' rel='nofollow'>SaSS</a>/<a href='https://www.heroku.com/' target='_blank' rel='nofollow'>Heroku</a> all have support on Linux and have command line tools that can be used in lieu of a GUI.

## Customizable.

Linux allows user to change desktop design and themes, add widgets and more. These changes can be done with desktop environments. Different environments have different set of options. Some popular ones are : KDE, GNOME, XFCE, Pantheon.

## It's Free.

Hard to beat that!
## It's safer.
Linux distributions have broadly two types of users, namely ROOT and NON-ROOT. There could be only 1 root user but multiple non-root users. Root users have the permission to do any modification (de-modification too!!!) to the system without the use of password (once asked while logging in). In case of non-root users they require permission from the root users to do any activity which could affect the system. So, browsing with non-root user is safe as just by clicking some sort of malicious links, it can't be installed and affect the system without the permission from root user.
