---
title: Getting Started
---
## Choosing a distribution.

There are various types of Linux distributions to choose from nowadays, and choosing one is the first step to getting started in the Linux world. Taking into consideration ease of use, the top dogs in this category are:
* [Ubuntu](https://www.ubuntu.com/) - Derivative of the stable Debian system, Ubuntu thrives as an easy to use and up-to-date environment.
* [Mint](https://linuxmint.com/) - Based on Ubuntu and Debian, this OS has great features like Ubuntu's PPA compatibility, the apt package manager. The default Mint distribution is reminiscent of Microsoft Windows, which can help to ease the transion for users coming from that environment. 
* [Trisquel](https://trisquel.info/) - A distribution  derived from Ubuntu that focuses on only utilizing fully free software, avoiding proprietary software. Trisquel is endorsed by the Free Software Foundation (FSF).

Some other choices include:
* [CentOS](https://www.centos.org/) - Based off of Red Hat Enterprise Linux. Community supported and stable.
* [Fedora](https://getfedora.org/) - Created by the Red Hat company to run newer packages than the stable enterprise releases. Community supported. 
* [Debian](https://www.debian.org/) - Created with completely free software. Many popular, "easy to use" derivatives are based off of Debian.
* [Arch](https://www.archlinux.org/) - An extremely customizable distribution. Not recommended for beginners.
* [Gentoo](https://www.gentoo.org/)
* [Suse](https://www.suse.com/) - One of the earliest distributions.  

### Ubuntu
One of the leading Linux distributions. It is also the perfect distro to begin your Linux journey.
Ubuntu is also known as the Linux for human beings now this is because Ubuntu has put lot of effort on universal usability. Ubuntu doesn’t require the user to be technically sound to use it in their daily life’s.

Ubuntu also offers a very convenient installation; the installer speaks in your major language with clear and easy steps. The installer provides simple options to make your life as easy as possible:
-	Install Ubuntu removing the older OS (The complete switch to the Linux life)
-	Install Ubuntu alongside the existing OS (A handy way to use Linux in your daily life but you can easily switch back to    
  Windows to perform duties not possible in Linux)
-	Configure partitions (For users who are more technically sound)

#### (Beginner tip: Select the second option if you are not sure about what to do.)

Ubuntu’s user interface is called Unity. It is as simple and productive as it gets. Running and favourite apps are displayed in the dock on the right side (This is called the Dash) and app search is bind to the Windows button. 

### Linux Mint Cinnamon
As described above Linux Mint is a distro that remind people of Windows, this reminder can help people to start their journey into the world of Linux. 

Linux Mint features the Cinnamon desktop environment. This desktop environment makes all the software are very accessibly grouped under categories. Linux mint is fast and run fine on older type of computers. 

The Linux mint distro is based on the rock-solid Ubuntu base, it also uses the same software repository as Ubuntu. Before software is pushed it get extensive testing this means that users will not have to deal with unexpected crashes and glitches that some new software are prone to.

Linux Mint Cinnamon is for this couple reasons a great start for people new to Linux world.

## Installing
Most Linux distributions are extremely easy to install, all information is shown between each step of the installation.

One important step to look out for is when deciding where to install your new Linux distro. For first-time users it's better to choose the "Guided" option as it will do all the work for you.

If you are trying to install a more complicated distrubution like Arch Linux, it is recommended you follow guides in the [wiki](https://wiki.archlinux.org/). Not only does the wiki contain great guides about Arch Linux, but also guides for many different Linux applications.

Remember to read all the steps carefully and leave some space in your HDD for the new distro, I would say about 30Gb minimum is nice to have.

## The Dreaded Terminal
Linux's terminal is not to be feared, actually it is quite easy to use with some practice and it can make our daily tasks easy to automate.

In Debian/Ubuntu and derivatives, the shortcut to open the CLI (Command Line Interface) is "Ctrl + Alt + T". Let's open the terminal and try some commands.

cd (Change Directory) - The cd command is one of the commands you will use the most at the command line in Linux. It allows you to change your working directory. You use it to move around within the hierarchy of your file system.

```unix
cd
```

Using the cd command alone will change the current directory to your user home directory, located in "/home/username" as in "/home/mark".

ls (List) - This command list the content in the current directory. It can also be used to list file information.

```sh
ls
```
Now we can see our directories in our home.


pwd (Print Working Directory) - This command lists the directory you are currently in.

```sh
pwd
```

## WSL
If you are only interested in learning to use the Linux command line, and currently working on a Windows 10 machine, you have the option of accessing a terminal through *Windows Subsystem for Linux (WSL)*.  Check out articles below to get started down this path!
- [How to Get Started Using WSL in Windows 10](https://www.linux.com/blog/learn/2018/2/how-get-started-using-wsl-windows-10 "How to Get Started Using WSL in Windows 10")
- [How to Install WSL on Windows 10](https://www.computerhope.com/issues/ch001879.htm "How to Install WSL on Windows 10") 

#### More Information
- ["The Linux Command Line" By William Shotts](http://linuxcommand.org/tlcl.php)
