---
title: Linux
---

# Linux

<img src="https://upload.wikimedia.org/wikipedia/commons/3/35/Tux.svg">

Linux is a name which broadly denotes a family of free and open-source software operating system distributions built around the Linux
kernel. The defining component of a Linux distribution is the Linux kernel, an operating system kernel first released on September 17,
1991 by Linus Torvalds. Many Linux distributions use the word "Linux" in their name. The Free Software Foundation uses the name
GNU/Linux to refer to the operating system family, as well as specific distributions, to emphasize that most Linux distributions are not
just the Linux kernel and that they have in common not only the kernel but also numerous utilities and libraries, a large proportion
of which are from the GNU project.

### GNU
The GNU operating system is a completely free software system, upward-compatible with Unix. GNU stands for “GNU's Not Unix”.
The project to develop the GNU system is called the “GNU Project”. The GNU Project was conceived in 1983 as a way of bringing back the cooperative spirit that prevailed in the computing community in earlier days—to make cooperation possible once again by removing the obstacles to cooperation imposed by the owners of proprietary software. *The GNU operating system and the Linux kernel are separate software projects that do complementary jobs. Typically they are packaged in a GNU/Linux distribution and used together*. More at [Overview of the GNU system](https://www.gnu.org/gnu/gnu-linux-faq.en.html#why)

The development of Linux is one of the most prominent examples of free and open-source software collaboration. The underlying source code may be used, modified and distributed commercially or non-commercially by anyone under the terms of its respective licenses, such
as the GNU General Public License.

Linux was first started as a clone of the MINIX operating system. Open source contributors added onto the kernel and expanded its
hardware compatibility. Linux's hardware support and free licensing made Linux a popular choice for desktop and server computing in the
mid-90s. Today, Linux is the most popular operating system in the world. It powers 90% of the world's servers and is the basis of
Google's popular Android operating system.

There are also many versions of Linux designed to be run on personal computers, such as Debian or Ubuntu. More importantly, these
different versions of Linux (called distributions or distros for short) allow the user varying degrees of personalization and control of the operating
system. This means that users can choose their Linux distributions based on their wants and needs.

There is also Kali Linux which is used for advanced penetration testing and auditing. It has over 700 tools, and to be able to use it efficiently, you will need to know how to use the command line. Since it is used for ethical hacking and pen testing, you will have to perform certain malicious hacks which might brick your system. Therefore, one should have complete knowledge about the command line interface, so that you can fix errors if they occur and know what you have done, hence it is not advised for beginners.

Other popular distributions of Linux include:

* Ubuntu
* Linux Mint
* Debian
* CentOS
* RHEL
* Arch Linux
* Gnome 3
* Elementary OS
* Tails

Package types are split between higher-level distributions, with Debian (.deb) and Red Hat (.rpm) being two of the most commonly used,
however, there are others including Pac-Man (used for Arch Linux) and PetGet (Puppy Linux).

Linux distributions also come in all shapes and size and most if not all offer the ability to run directly via CD / DVD in what's known
as a 'Live CD' environment or even directly via USB if your motherboard supports booting from USB.

For more facts about Linux, read Quincy Larson's article [Linux is 25. Yay! Let’s celebrate with 25 stunning facts about Linux](https://medium.freecodecamp.org/linux-is-25-yay-lets-celebrate-with-25-rad-facts-about-linux-c8d8ac30076d).
