---
title: The Linux, Apache, MySQL, and PHP Stack
---

## The LAMP Stack

One of the most common configurations for a Linux server is the LAMP stack, named after the most frequently used components (Linux, Apache, MySQL, and PHP). The standard LAMP stack is open source, freely available, and thoroughly documented, providing a flexible, standardized, and secure platform for website and web application development. 

### Linux

The operating system component of the LAMP stack is usually a distribution of Linux, and many popular Linux distributions such as Ubuntu and Red Hat have semi-automated methods for installed and configuring the other components. When Mac OSX is substituted for Linux, the resulting stack is sometimes referred as the MAMP stack. Similarly, when the stack is built in a Windows environment, it is sometimes referred to as a WAMP stack. 

### Apache

The web server component of the stack is usually Apache, the most popular web server on the internet. As of June 2014, Apache was estimated to serve 52.27% of all active websites. In recent years, many sysadmins and web developers have opted to replace Apache with nginx, a web server that can be more lightweight and faster in some situations. The resulting stack is sometimes referred to as the LEMP stack. 

### MySQL

The relational database management system (RDBMS) layer of the LAMP stack is MySQL. It is sometimes replaced by MariaDB, a performant fork of MySQL, or even unrelated databases such as PostgreSQL or NoSQL databases such as MongoDB. 

### PHP

The server programming language or middleware layer of the LAMP stack is usually PHP, though it has frequently been substituted with (or used alongside) Python, Perl, or other languages. "Hypertext Preprocessor is a server-side scripting language designed for Web development, but also used as a general-purpose programming language." - As defined by Google

