---
title: Linux Brief History
---
## Linux in Brief

GNU/Linux (commonly referred to as just Linux) is a free, open-source, customizable operating system based on the Linux kernel and GNU utilities and libraries.  It is developed by thousands of developers and used by millions of people, companies, and governments around the world. It is an alternative solution to other OS's such as Windows and Mac OSX and comes in many different distributions or "flavors."  Some of the most popular distributions are Ubuntu, Red Hat Enterprise Linux (RHEL), Debian, Fedora, CentOS, OpenSuSE, Arch, Mint, and Solus. It includes software found in other OS's for common tasks such as running office applications, multimedia, graphics, and gaming. It also provides powerful tools for programming and web development. Linux is built to run on desktops, servers, Internet Of Things devices and mobile devices (Android).

## Who invented Linux?

Linux is germinated as an idea in the mind of young and bright <b>Linus Torvalds</b> when he was a computer science student. He used to work on the UNIX OS (proprietary software) and thought that it needed improvements. 
However, when his suggestions were rejected by the designers of UNIX, he thought of launching an OS which will be receptive to changes, modifications suggested by its users.
So Linus devised a Kernel named Linux in 1991. However, he would still need programs like File Manager, Document Editors, Audio -Video programs to run on it.
As time passed by, he collaborated with other programmers in places like MIT and applications for Linux began to materialize. So, around 1991, a working Linux operating system with some applications was officially launched. This was the start of one of the most loved and open-source OS options available today. 
The earlier versions of Linux were not so user-friendly as they were in use by computer programmers and Linus Torvalds never had it in mind to commercialize his product. 
This definitely curbed Linux's popularity while another commercially oriented operating system, Windows, got famous. Nonetheless, the open-source aspect of the Linux operating system made it more robust and accessible. 

#### More Information:

[Linux on Wikipedia](https://en.wikipedia.org/wiki/Linux)

[Kernel.org - the Linux kernel official website](https://www.kernel.org/)

[Distrowatch - the reference for Linux distributions](http://distrowatch.com)
