---
title: Origins of Linux and the Free Software Movement
---
In the 1980s a famous MIT hacker working for the Artificial Intelligence Lab named <a href='https://en.wikipedia.org/wiki/Richard_Stallman' target='_blank' rel='nofollow'>Richard Stallman</a> promoted the sharing of knowledge and ideas freely, specifically within the area of software. <a href='https://en.wikipedia.org/wiki/Unix' target='_blank' rel='nofollow'>UNIX</a> was the <a href='https://en.wikipedia.org/wiki/Operating_system' target='_blank' rel='nofollow'>operating system</a> (OS) of choice by many in the engineering and scientific community, but the problem was UNIX was <a href='https://en.wikipedia.org/wiki/Proprietary_software' target='_blank' rel='nofollow'>proprietary software</a>. This meant only the vendors of the OS had access to the <a href='https://en.wikipedia.org/wiki/Source_code' target='_blank' rel='nofollow'>source code</a>. That went against Stallman's philosophy. Not only did this mean the end users were not allowed to see how the software worked, they could not make any improvements or fixes to it if they could.

Stallman started the <a href='https://en.wikipedia.org/wiki/Free_Software_Foundation' target='_blank' rel='nofollow'>Free Software Foundation</a> (FSF) which supported the <a href='https://en.wikipedia.org/wiki/Free_software_movement' target='_blank' rel='nofollow'>free software movement</a>'s ideals (Individuals who use and collaboratively contribute to open and free software). It was also responsible for starting the <a href='https://en.wikipedia.org/wiki/GNU_Project' target='_blank' rel='nofollow'>GNU Project</a> in 1984 which was the first attempt at a free OS that was not UNIX (GNU is a <a href='https://en.wikipedia.org/wiki/Recursive_acronym' target='_blank' rel='nofollow'>recursive acronym</a> for 'GNUs not UNIX'). The GNU Project would include everything useful found on a UNIX system but written from scratch. More importantly, along with the OS the source code would also be legally available to those who wanted it. The idea was that freely exchanging the source code and inner knowledge of the OS would encourage collaborative development, which in turn would create a better OS product. The GNU Project eventually led to the <a href='https://en.wikipedia.org/wiki/GNU_General_Public_License' target='_blank' rel='nofollow'>GNU Public License</a> (GPL) which legalized all software released under it to be made freely available as well as require providing the source code. While the GPL was a success and still used today to license free software, the GNU Project never took off as planned. Another hacker stepped in and provided his implementation of a free Operating System to the world instead.

<a href='https://en.wikipedia.org/wiki/Linus_Torvalds' target='_blank' rel='nofollow'>Linus Torvalds</a>, a Finnish student from the University of Helsinki, first created <a href='https://en.wikipedia.org/wiki/Linux' target='_blank' rel='nofollow'>Linux</a> kernel while experimenting with a free and smaller version of UNIX used for educational purposes called <a href='https://en.wikipedia.org/wiki/MINIX' target='_blank' rel='nofollow'>MINIX</a> which was developed by <a href='https://en.wikipedia.org/wiki/Andrew_S._Tanenbaum' target='_blank' rel='nofollow'>Andrew Tanebatum</a>. Linus wanted to have a similar free OS that didn't have the constraints of being limited to pure educational use. He created Linux which he licensed under the GPL and distributed on the Internet in 1991 (The current source code and work on the Linux Kernel can be found on GitHub <a href='https://github.com/torvalds/linux' target='_blank' rel='nofollow'>here</a>. Linus didn't use any code from MINIX, but he incorporated the features found in MINIX/UNIX which is why Linux is often called <a href='https://en.wikipedia.org/wiki/Unix-like' target='_blank' rel='nofollow'>"UNIX-like"</a> or a "UNIX clone".

Despite the fact that GNU Project never created fully-fledged free OS it did create a lot of system software for interacting with the kernel that is vital for a well functioning OS. Thus the combination of Linux kernel and GNU core system programs made the fully free OS possible.

Over time Linux began to gather strong traction within the free software movement. Thousands of developers around the world started experimenting and using it, making contributions where they saw fit. As it became more stable and feature-rich, businesses slowly started to adopt Linux as a solution for their needs and even started contributing to Linux themselves. Linux reaches many devices and environments to this day and continues to grow in popularity.
