---
title: Monty Hall Problem
---
## Monty Hall Problem

The Monty Hall Problem is a riddle on probability named after the host of the 70's game show it's based on, Let's Make a Deal. This particular problem is a veridical paradox. This means that there is a solution that seems counter-intuitive, yet proven to be true.

The problem defines as follows; You are in a game show and there are 3 doors, each with a different prize behind them. Behind one of the three doors is a car. The other two have goats. You must choose one of the 3 doors to select as your prize. Say you pick Door 1 but before the door opens Monty decides to open Door 2 which reveals a goat. He now asks if you would like to choose Door 3 instead. Should you choose Door 3 over your original choice? Does it even matter?

It turns out that the choice does matter and it is actually to your benefit to switch your decision to Door 3! Here's why. When you chose Door 1 from the 3 closed doors, you had a 1 out of 3 chance that you picked the right one. Both Door 2 and Door 3 also have a 1 out of the 3 chance of having a car behind it. You could also say that Doors 2 and 3 have a 2 out of 3 chance of having a car behind it *combined*.

![Probability before revealing a goat](https://i.imgur.com/8EsVvZk.png "Probability before revealing a goat")

Now, when the host opens Door 2 and it contains a goat you now have more information about the problem. Remember that Doors 2 and 3 have a combined probability containing a car 2/3rds of the time. With the door reveal you know that Door 2 does not have a car. This reveal does not change the combined probability of the two doors, that's the key takeaway here! Since we now know Door 2 has a 0/3 chance of showing a car, you can now say that Door 3 has a 2/3rds chance of containing a car. Combining the probabilities of Door 2 and Door 3 still add up to 2/3rds as it was before Door 2 opened. Door 1 remains unchanged and only has a 1/3rd chance. So, if you decide to switch you go from roughly a 33.33% chance to 66.67% of picking the car. In other words, you are doubling your chances of success by switching!

![Probability after revealing a goat](https://i.imgur.com/V2JzAka.png "Probability after revealing a goat")

Yes, it is possible that Door 1 had the car all along and Monty tricked you. That doesn't matter. You are gambling by taking the deal but you're gambling smart. You make your best decision with the information you're given and let the dice roll. In the long run, you perform better switching than a contestant who decides to keep their first pick. In the end, Monty actually tricks himself offering you a better deal.

#### More Information:

<a href="https://www.youtube.com/watch?time_continue=1&v=4Lb-6rxZxx0" target="_blank" rel="nofollow">Monty Hall Problem - Numberfile</a>

<a href="https://www.youtube.com/watch?v=YReov4c3taI" target="_blank" rel="nofollow">21 Kevin Spacey Monty Hall Problem</a>


#### More Information:
- Monty Hall problem article: [Wikipedia](https://en.wikipedia.org/wiki/Monty_Hall_problem)
