---
title: Natural Language Processing
---
## Natural Language Processing(NLP)

According to Wikipedia, "Natural language processing (NLP) is a subfield of computer science, information engineering, and artificial intelligence, concerned with the interactions between computers and human (natural) languages, in particular how to program computers to process and analyze large amounts of natural language data."

In simpler terms, it is a process in which natural language generated by humans are made sense of by computers.

### Challenges in NLP
#### 1.Easy or mostly solved
			  *Spam detection
			  *Part of Speech Tagging
			  *Named Entity Recognition
#### 2.Intermediate or making good progress
			  *Sentiment analysis
			  *Coreference resolution
			  *Word sense disambiguation
			  *Parsing
			  *Machine Translation
			  *Information Translation
#### 3.Hard or still need lot of work
			  *Text Summarization
			  *Machine dialog system

### Common Techniques
			 *Structure extraction
			 *Identify and mark sentence, phrase, and paragraph boundaries
			 *Language identification
			 *Tokenization
			 *Acronym normalization and tagging
			 *Lemmatization / Stemming
			 *Entity extraction
			 *Phrase extraction
       *Text summarization
		
### Popularly Used Libraries
		  *NLTK, the most widely-mentioned NLP library for Python.
			*SpaCy, an industrial-strength NLP library built for performance.
			*Gensim, a library for document similarity analysis.
			*TextBlob, a user-friendly and intuitive NLTK interface.
			*CoreNLP from Stanford Group
			*PolyGlot, a natural language pipeline that supports massive multilingual applications.
      *Pattern, used for web crawling, NLP tasks, and machine learning.
			 
#### More Information:
<!-- Please add any articles you think might be helpful to read before writing the article -->
For further reading:

- Click <a href="https://medium.com/@gon.esbuyo/get-started-with-nlp-part-i-d67ca26cc828"  target='_blank' rel='nofollow'>here</a> for an article about NLP intro.
- Click <a href="https://en.wikipedia.org/wiki/Natural_language_processing" target='_blank' rel='nofollow'>here</a> for the Wikipedia reference.
