---
title: Intuition Fails in High Dimensions
---
## Intuition Fails in High Dimensions

#### Imagine
A 2D plane with `X` and `Y` axis. On it you mark points `(1,0)` and `(0,1)`. And through them you draw a straight line. Even without looking at the image below, one can get an idea about how the graph would look like.

![X-Y plane with your imaginary line](https://ka-perseus-graphie.s3.amazonaws.com/466568bad0126c402380ff2ea57aad004f36172b.svg)

Now let's imagine a 3D plane with `X`, `Y` and `Z` axis. Through this 3D structure, a plane passes that intersects the `X`axis at `(2, 0, 0)`, `Y` axis at `(0, 3, 0)` and `Z` Axis at `(0, 0, 6)`. Such a plane is tough to imagine in our heads, but if we try we would end up with something that looks like this.

![X-Y-Z with our plane](http://tutorial.math.lamar.edu/Classes/CalcIII/SurfaceArea_files/image001.gif)

With that, we get to step into the next higher dimesion. Planes in dimensions higher than `3` are refered to as hyperplanes. But first let us address just where does the fourth axis even point to. Let's call it `W` axis. And similar to previous cases of new Axis creation, this `W` axis would be perpendicular to pre-existing axes (`X`, `Y` and `Z`). Just like `Z` was perpendicular to `X` and `Y` axes.

![X-Y-Z-W Axes](http://eusebeia.dyndns.org/4d/vis/4d-axes.png)

> It is important to understand that the W-axis as depicted here is perpendicular to all of the other coordinate axes. We may be tempted to try to point in the direction of W, but this is impossible because we are confined to 3-dimensional space.

Because we live in a world that is 3-dimensional, its difficult for us to comprehend the world that has dimensions higher than 3. This is the reason for our intuition and imagination to be of limited help in higher dimensions.


<!-- The article goes here, in GitHub-flavored Markdown. Feel free to add YouTube videos, images, and CodePen/JSBin embeds  -->

#### More Information:
* <a href="http://eusebeia.dyndns.org/4d/vis/01-intro">4D Visualization and Why It Matters</a>
<!-- Please add any articles you think might be helpful to read before writing the article -->


