---
title: Absolute Value
---
## Absolute Value

Absolute value is the non-negative value of a number, whether that number is positive or negative.
You can think of a number's absolute value as its distance from zero.
It can be also be considered as magnitude without direction.
It can be defined as,

![img](https://latex.codecogs.com/gif.latex?%5Cdpi%7B120%7D%20%5Clarge%20y%20%3D%20%5Cleft%20%7C%20x%20%5Cright%20%7C%20%3D%20%5Cleft%5C%7B%5Cbegin%7Bmatrix%7D%20x%20%26%20for%20%5C%2C%20x%20%5Cgeq%200%20%5C%5C%20-x%20%26%20for%20%5C%2Cx%20%3C0%20%5Cend%7Bmatrix%7D%5Cright.)

<img src="https://upload.wikimedia.org/wikipedia/commons/thumb/6/6b/Absolute_value.svg/2000px-Absolute_value.svg.png" width="300">  

The absolute value of a quantity x is denoted by |x| (the quantity is enclosed between two vertical bars).
Here you can see that in the graph of y = |x|, if -2 is input in to the function, 2 is the result. This is because -2 has a distance of 2 from zero. The absolute value of a number can never be negative. 

For complex numbers, this is also referred to as the *modulus*. 

```
Pythagorean Theorem: If z=a+bi, where a=Re{z} and b=Im{z}, then |z|=sqrt(a^2+b^2)
```

![i](https://1.bp.blogspot.com/-a9-goSuDZpY/VdtnQqPMRXI/AAAAAAAABbA/3U519TdTKgU/s400/modulo%2Bnumero%2Bcomplejo.png)

### Examples

* **Simplify |-5|**

  |-5| = 5

* **Simplify |0(5)|**

  |0(5)| = |0| = 0

* **Simplify -|-1|**

  -|-1| = -(1) = -1

* **Simplify |-5(-3) + 1|**

  |-5(-3) + 1| = |15 + 1| = |16| = 16

* **Simplify |8|**

  |8| = 8
  
* **Simplify |(-5)^3|**

|(-5)^3| = |-125| = 125

* **Simplify -|(4)^2|**
-|16| = -16

#### More Information:
[Purplemath](https://www.purplemath.com/modules/absolute.htm)


