---
title: Accuracy and Precision
---
## Accuracy and Precision

Accuracy and Precision are often used interchangeably, but mean different things.

### Accuracy is about closeness to the true value

In science and engineering, the accuracy of a measurement is the degree of closeness or trueness of that measurement to the true value of the quantity being measured.

For example, a ruler that measures a known length of 1 meter as 1 meter would have high accuracy; a ruler that measures the same distance as 0.8 meter would have low accuracy. Another example would be if you are trying to measure pi, the accuracy would be determined by how close your measurements are to the known value of pi: 3.141592...

### Precision is about variability in repeat measurements

The precision of a measurement is the repeatibility of that measurement and expresses the variability within it. In other words, precision is being able to getting close to or the same measurements every time.

For example, if the ruler mentioned above that measured 1 meter as 0.8 meter, measured the distance as 0.80 m, 0.79 m, 0.80 m, 0.81 m and 0.80 m over successive measurements the ruler would be quite precise (the measurements have low variability), while being inaccurate. Additionally, using the pi example as above, if your measurments constantly get 3.12, then they are precise, but not accurate.

### Precision and accuracy are independent from each other

The precision of a measurement is independent of the accuracy of the measurement. Likewise the accuracy of a measurement is independent of its precision. This means that measurements can be precise and of low accuracy, accurate and of low precision, precise and accurate, and imprecise and inaccurate.
  
### Archery analogy

A good analogy for understanding accuracy and precision is to imagine an archer shooting arrows at a target. If the archer shoots with accuracy, their aim will take the arrow close to or into the center of the target (or bull's eye). If the archer shoots with precision, their aim will take each arrow to the same location, which may or may not be close to the bull's eye. A good archer will be both accurate and precise by hitting near or in the bull's eye each time, and grouping all the arrows in the same part of the target (see the image below). 

<img src="http://cdn.antarcticglaciers.org/wp-content/uploads/2013/11/precision_accuracy.png">

#### More Information:
<!-- Please add any articles you think might be helpful to read before writing the article -->

- [Accuracy and Precision from Statistics How To](http://www.statisticshowto.com/accuracy-and-precision/)
- [Accuracy vs Precision from Mr. Evans' Science Website](https://sites.google.com/a/apaches.k12.in.us/mr-evans-science-website/accuracy-vs-precision)
- [Accuracy and precision from Wikipedia](https://en.wikipedia.org/wiki/Accuracy_and_precision)
