---
title: Adding Fractions
---
## Adding Fractions

A fraction is generally used to represent a number which is a ratio of two numbers. 
<br>Consider the fraction <span class="fraction"><sup>4</sup>⁄<sub>5</sub></span>, here 4 is called the numerator and 5 is called the denominator. 

#### Adding fractions with common denominator

Add the numerators of both fractions and put the resultant over the denominator.

###### Example 1

Consider fractions <span class="fraction"><sup>4</sup>⁄<sub>5</sub></span> and <span class="fraction"><sup>3</sup>⁄<sub>5</sub></span>

1. The denominator of the fractions is common.
2. The numerators are 4 and 3
3. Add the numerators, 4 + 3 = 7
4. Place the resultant over the common denominator
5. Simplify the resultant fraction, if possible

<pre>  <span class="fraction"><sup>4</sup>⁄<sub>5</sub></span> + <span class="fraction"><sup>3</sup>⁄<sub>5</sub></span> = <span class="fraction"><sup>7</sup>⁄<sub>5</sub></span> </pre>
###### Example 2
<pre>  <span class="fraction"><sup>5</sup>⁄<sub>16</sub></span> + <span class="fraction"><sup>3</sup>⁄<sub>16</sub></span> = <span class="fraction"><sup>8</sup>⁄<sub>16</sub></span> (Simplifying it further, <span class="fraction"><sup>8</sup>⁄<sub>16</sub></span> = <span class="fraction"><sup>1</sup>⁄<sub>2</sub></span>) </pre>

#### Adding fractions with different denominators

1. Convert the fractions to equivalent fractions with common denominator
2. To convert two fractions to common denominator, multiply the numerator and denominator of a fraction with the denominator of the other fraction.
3. Now that the fractions have common denominators, add the numerators of both fractions and put the resultant over the denominator

   Consider, <span class="fraction"><sup>a</sup>⁄<sub>b</sub></span> and <span class="fraction"><sup>c</sup>⁄<sub>d</sub></span>  are fractions with different denominators, you can add these fractions in a single step like below,
<br>
<pre>  <span class="fraction"><sup>a</sup>⁄<sub>b</sub></span> + <span class="fraction"><sup>c</sup>⁄<sub>d</sub></span> = <span class="fraction"><sup>(a * d) + (b * c)</sup>⁄<sub>(b * d)</sub></span> </pre>

###### Example

Consider fractions <span class="fraction"><sup>5</sup>⁄<sub>6</sub></span> and <span class="fraction"><sup>5</sup>⁄<sub>15</sub></span>

1. The denominators are different. So you need to make the denominators common
2. Before that, if possible, simplify the fractions. In this case, <span class="fraction"><sup>5</sup>⁄<sub>15</sub></span> can be simplified as <span class="fraction"><sup>1</sup>⁄<sub>3</sub></span>. Here <span class="fraction"><sup>5</sup>⁄<sub>15</sub></span> and <span class="fraction"><sup>1</sup>⁄<sub>3</sub></span> are called equivalent fractions.
3. After simplification, the fractions are <span class="fraction"><sup>5</sup>⁄<sub>6</sub></span> and <span class="fraction"><sup>1</sup>⁄<sub>3</sub></span>.
4. Now to add these fractions, you must make the denominators common
5. Multiply the numerator and denominator of a fraction with denominator of the other
6. For fraction <span class="fraction"><sup>5</sup>⁄<sub>6</sub></span> , the denominator of the other fraction is 3. For fraction <span class="fraction"><sup>1</sup>⁄<sub>3</sub></span> , the denominator of the other fraction is 6

<pre>  <span class="fraction"><sup>((5 * 3) + (1 * 6))</sup>⁄<sub>(6 * 3)</sub></span> = <span class="fraction"><sup>21</sup>⁄<sub>18</sub></span> </pre>

7. The resultant fraction is <span class="fraction"><sup>21</sup>⁄<sub>18</sub></span>. This can be further simplified as <span class="fraction"><sup>7</sup>⁄<sub>6</sub></span>

<pre>  <span class="fraction"><sup>5</sup>⁄<sub>6</sub></span> + <span class="fraction"><sup>5</sup>⁄<sub>15</sub></span> = <span class="fraction"><sup>7</sup>⁄<sub>6</sub></span> </pre>

<span class="fraction"><sup>7</sup>⁄<sub>6</sub></span> is equivalent to 1 and <span class="fraction"><sup>1</sup>⁄<sub>6</sub></span>
