---
title: Polynomial Factorization
---
## Polynomial Factorization

Factoring polynomials is a lot like factoring regular numbers. The goal is to find numbers or polynomials that divide out evenly from the polynomial. In contrast to factoring, you can simplify 
an expression like so:

<img alt='7(x+4) = 7x + 28' src="https://github.com/codersc/freeCodeCamp-article-images/blob/master/art6img1.png?raw=true">

You can think of factoring as doing the opposite, like in this example where we first find the greatest common factor (GCF) of the terms (9) and then rewrite the polyynomial:

<img alt='9x^2 + 72 = 9(x^2 + 8)' src="https://github.com/codersc/freeCodeCamp-article-images/blob/master/art6img2.png?raw=true">

Let's do some more examples.

<img alt='2x - 10' src="https://github.com/codersc/freeCodeCamp-article-images/blob/master/art6img3.png?raw=true">

You can factor the first term in to (2)(x) and the second in to (-5)(2). The only common factor is 2.
Move the common factor out to the beginning of our rewritten polynomial.

<img alt='2x - 10 = 2(' src="https://github.com/codersc/freeCodeCamp-article-images/blob/master/art6img4.png?raw=true">

When you divide 2 out of 2x you're left with x

<img alt='2x - 10 = 2(x' src="https://github.com/codersc/freeCodeCamp-article-images/blob/master/art6img5.png?raw=true">

When you divide 2 out of -10 you're left with -5.

<img alt='2x - 10 = 2(x - 5)' src="https://github.com/codersc/freeCodeCamp-article-images/blob/master/art6img6.png?raw=true">

### Common Mistakes

<img alt='x^6y^5 + xy = xy(x^5y^4 + 1)' src="https://github.com/codersc/freeCodeCamp-article-images/blob/master/art6img7.png?raw=true">

In this case, xy is not a factor of the original equation because it is not the same term as x^6y^5. When factoring, often times you'll end up with a division that results in 1. Make sure to include it in the parentheses.
