---
title: Simplifying Square Roots
---

### Example: Simplify <img src="https://latex.codecogs.com/gif.latex?\sqrt{180}" title="\sqrt{180}" />

Solution steps:
* Break 180 into product of prime number factors: <img src="https://latex.codecogs.com/gif.latex?180&space;=&space;2^2&space;*&space;3^2&space;*&space;5" title="180 = 2^2 * 3^2 * 5" />
* Use product property of radicals <img src="https://latex.codecogs.com/gif.latex?\sqrt{ab}&space;=&space;\sqrt{a}\sqrt{b}&space;\Rightarrow&space;\sqrt{180}&space;=&space;\sqrt{2^2}\sqrt{3^2}\sqrt{5}=2*3\sqrt{5}=6\sqrt{5}" title="\sqrt{ab} = \sqrt{a}\sqrt{b} \Rightarrow \sqrt{180} = \sqrt{2^2}\sqrt{3^2}\sqrt{5}=2*3\sqrt{5}=6\sqrt{5}" />  
We cannot simplify square root of a prime number thus final answer: <img src="https://latex.codecogs.com/gif.latex?\sqrt{180}&space;=&space;6\sqrt{5}" title="\sqrt{180} = 6\sqrt{5}" />

### Example: Simplify <img src="https://latex.codecogs.com/gif.latex?\sqrt{1750}" title="\sqrt{1750}" />

Solution steps:
* Break 1750 into product of prime number factors: <img src="https://latex.codecogs.com/gif.latex?1750&space;=&space;2*7*5^3" title="1750 = 2*7*5^3" />
* Use product property of radicals and keep breaking down the results: <img src="https://latex.codecogs.com/gif.latex?\sqrt{ab}&space;=&space;\sqrt{a}\sqrt{b}&space;\Rightarrow&space;\sqrt{1750}&space;=&space;\sqrt{2}\sqrt{7}\sqrt{5^3}&space;=&space;\sqrt{2}\sqrt{7}\sqrt{5}\sqrt{5^2}&space;=&space;5\sqrt{2}\sqrt{7}\sqrt{5}" title="\sqrt{ab} = \sqrt{a}\sqrt{b} \Rightarrow \sqrt{1750} = \sqrt{2}\sqrt{7}\sqrt{5^3} = \sqrt{2}\sqrt{7}\sqrt{5}\sqrt{5^2} = 5\sqrt{2}\sqrt{7}\sqrt{5}" />  
Now use product property again to combine radicals which cannot be simplified: <img src="https://latex.codecogs.com/gif.latex?5\sqrt{2}\sqrt{7}\sqrt{5}&space;=&space;5\sqrt{70}" title="5\sqrt{2}\sqrt{7}\sqrt{5} = 5\sqrt{70}" />

### Terminology:

Using &radic;49 as an example:
* "&radic;" is called **radical symbol**.
* 49 is called **radicand**.

#### More Information:

* [Wikihow, simplifying a square root](https://www.wikihow.com/Simplify-a-Square-Root)
* [Khan Academy](https://www.khanacademy.org/math/algebra/rational-exponents-and-radicals/alg1-simplify-square-roots/a/simplifying-square-roots-review)
