---
title: The Quadratic Formula
---

## The Quadratic Formula

This is a simple formula we can get by solving the basic representation of a quadratic equation for x:

          ax^2 + bx + c = 0

where a, b, c are the coefficient placeholders (or the constants in a real equation)
and x is the variable for which the value needs to be found.

Solving for x, we get the quadratic formula as:

        x = (-b +- sqroot(b^2 - 4ac)) / (2a)

This is represented in a more **clear** way here:
![here](https://wikimedia.org/api/rest_v1/media/math/render/svg/2a9804ca8ce019507e3199ca8fced800fb5b7d7c)

### Implications of the formula on finding solutions:

Just by a glance, we can conclude a few statements for any quadratic equation in Real Number Domain and Range:

Consider the expression under the square root "b^2 - 4ac" as E. This E is known as **discriminant**.  

1. If E is positive, then we will have 2 distinct real solutions for x (property of squares)
2. If E is zero, then there is one and only one solution for x
3. If E is negative, then there is no **real** solution for x

The quadratic formula is a tool for solving quadratic equations. A quadratic equation is a polynomial equation of degree two.
A degree two polynomial is just a polynomial where the highest exponent of _x_ is 2. Following are the examples of quadratic equations.

* ![x^2-5x+6=0](https://github.com/jasonu/freecodecamp-images/blob/master/quadratic_integer_roots.png "example quadratic equation")
* ![x^2+x-1=0](https://github.com/jasonu/freecodecamp-images/blob/master/quadratic_irrational_roots.png "example quadratic equation")

The formula only applies to equations that have the form above where a polynomial equals zero.
In general, the formula applies to equations which have the form:

<!-- Generated via latex2png.com resolution=150 dpi, src: $ax^2 + bx + c = 0$ -->
![ax^2+bx+c=0](https://github.com/jasonu/freecodecamp-images/blob/master/quadratic_equation.png "general quadratic equation")

Where _a_, _b_ and _c_ are coefficients of the polynomial. In this case the equation will have solution(s):

<!-- Generated via latex2png.com resolution=150 dpi, src: $x = \frac{-b \pm \sqrt{b^2 - 4ac}}{2a}$ -->
![quadratic formula](https://github.com/jasonu/freecodecamp-images/blob/master/quadratic_formula.png "quadratic formula")

#### Example:
Suppose you wish to find the solutions to: ![x^2-5x+6=0](https://github.com/jasonu/freecodecamp-images/blob/master/quadratic_integer_roots.png "example quadratic equation"), then by plugging _a=1, b=-5, c=6_ into the quadratic formula we get:
* _x=2_,
* _x=3_.


#### Example:
The solution to: ![x^2+x-1=0](https://github.com/jasonu/freecodecamp-images/blob/master/quadratic_irrational_roots.png "example quadratic equation")
is obtained by setting _a=1, b=1, c=-1_ in the quadratic formula. This gives two irrational solutions or roots:
* _x=(-1+√5)/2_,
* _x=(-1-√5)/2_.

The Quadratic Formula can be used to find the solution(s) of any quadratic equation, and by looking at the discriminant, one can determine the number and nature of solutions.  Other methods, such as factoring, graphing, or completing the square finds the solution(s) of a quadratic equation, but the Quadratic formula is very useful in cases where you can't factor or graph. 

When writing the quadratic equation as:

![ax^2 + bx + c = 0](https://wikimedia.org/api/rest_v1/media/math/render/svg/70a0e43dfc81e6fea3be4fc96895a8f9ec2966ac/)

(x is the variable while a, b, and c are constants)

The quadratic formula is:

![x=-b +/- sqrt(b^2 - 4ac) all over 2a](https://wikimedia.org/api/rest_v1/media/math/render/svg/2a9804ca8ce019507e3199ca8fced800fb5b7d7c/)


### Discriminant
The discriminant is everything under the radical in the quadratic formula. ![b^2 - 4ac](http://www.katesmathlessons.com/uploads/1/6/1/0/1610286/what-is-the-discriminant_orig.png/)

If the discriminant = 0, then the quadratic only has one solution.  Graphically, this represents the vertex being placed on the x axis.

If the discriminant is positive ( > 0 ), then the quadratic has two real solutions or roots.  This represents the quadratic intersecting the x axis in two places.

If the discriminant is negative ( < 0 ), the the quadratic has no real solutions (two imaginary solutions).  This is because you cannot take the square root of a negative.  Grapically, this represents the function not passing through the x axis.

### Memorization
More often than not, you will be required to memorize the quadratic formula.  Here are some helpful mnemonic devices:

There are several [songs](https://www.youtube.com/watch?v=2lbABbfU6Zc/) that help.

In addition, creating a story to remember the quadratic formula helps.  For example: The negative boy was unsure (plus or minus) to go to the radical party, but because he was so square, he missed out on four awesome chicks.  The party was all over at 2Am.

### Common Mistakes:
A lot of people forget about Order of Operations and subtract 4 before multiplying it to a and c.

In addition, the 2a is underneath the whole thing, not just the square root.

Make sure that you are careful not to drop the square root or the "plus/minus" in the middle of your calculations.

Remember that "b^2" means "the square of ALL of b, including its sign", so don't leave b^2 being negative.

#### More Information:
[The Quadratic Formula Explained](http://www.purplemath.com/modules/quadform.htm "The Quadratic Formula Explained")

[Wikipedia - Quadratic formula](https://en.wikipedia.org/wiki/Quadratic_formula/)

[Purple Math](http://www.purplemath.com/modules/quadform.htm/)

[Khan Academy](https://www.khanacademy.org/math/algebra/quadratics/solving-quadratics-using-the-quadratic-formula/a/quadratic-formula-explained-article/)
