---
title: All Factors of a Number
---
## All Factors of a Number

You can think of factors as the whole numbers that you multiply to get another whole number. Factorizing is only applicable for the whole numbers.

<img src="https://upload.wikimedia.org/wikipedia/commons/e/e8/Factor_Tree_of_42.png" width="90">

In this case 2, 3, 6, and 7 are all numbers you can multiply to get 42. So, they are all factors of 42. However, it is not the full list of factors of 42. To find all the factors we can use the algorithm or step by step by process below.

Start with 1, as it it the factor for any number. 

1 * 42 = 42

1 | ... | 42
--- | --- | ---

Then, follow with successively increasing numbers.

Try 2. 

2 * 21 = 42

1 | 2 | ... | 21 | 42
--- | --- | --- | --- | ---

Try 3. 

3 * 14 = 42

1 | 2 | 3 | ... | 14 | 21 | 42
--- | --- | --- | --- | --- | --- | ---

Try 4.

No whole number can be multiplied by 4 to get 42, so we skip it.

Try 5.

No whole number can be multiplied by 5 to get 42, so we skip it.

Try 6.

6 * 7 = 42


1 | 2 | 3 | 6 | ... | 7 | 14 | 21 | 42
 --- | --- | --- | --- | --- | --- | --- | --- | ---

Since there are no whole numbers between 6 and 7, all of the positive factors have been found. All of the numbers above are to have their sign flipped and are also the factors of 42. In conclusion, all the factors of 42 are below.

1 | 2 | 3 | 6 | 7 | 14 | 21 | 42 | -1 | -2 | -3 | -6 | -7 | -14 | -21 | -42
 --- | --- | --- | --- | --- | --- | --- | --- | --- | --- | --- | --- | --- | --- | --- | ---

## Confirm number of factors is correct
We can quickly confirm that we have identified all positive factors with the following steps:

1. Take the prime factorization (provided by tree above)

2<sup>1</sup> * 3<sup>1</sup> * 7*<sup>1</sup>


2. Add one to each of the exponents:

2's exponent: 1 + 1 = 2
3's exponent: 1 + 1 = 2
7's exponent: 1 + 1 = 2


3. Multiple each of the numbers above:

2 * 2 * 2 = 8


4. Confirm that 42 has 8 factors: 

1 | 2 | 3 | 6 | ... | 7 | 14 | 21 | 42
 --- | --- | --- | --- | --- | --- | --- | --- | ---

