---
title: Area of a Square
---

## Area of a Square

A square is a quadrilateral with identical sides.

The area of a square can be calculated either from the length of the side, or from the length of the diagonal.

![Square](https://github.com/viso-gio/HostedImages/blob/master/square.jpg?raw=true)

If the side *a* is known:

![Formula1](https://github.com/viso-gio/HostedImages/blob/master/AreaSquare1.png?raw=true)

If the diagonal *d* is known:

![Formula2](https://github.com/viso-gio/HostedImages/blob/master/AreaSquare2.png?raw=true)

The relationship between side *a* and diagonal *d* is:

![Diagonal](https://github.com/viso-gio/HostedImages/blob/master/DiagonalSquare.png?raw=true)

### Terminology

Diagonal - the distance from opposite corners of a square. The corners are 90-degrees.

Perimeter - the sum of the length of four sides in a square. The four sides are equal in a square.

### Examples

1. Given length of one side of square is 8 units:

<pre>   Area = 8 x 8 = 64 units<sup>2</sup> </pre>
      
2. Given area of a square is 100 units<sup>2</sup>:

  <pre> Length = <span>&#8730;</span>100 = 10 units </pre>
   
3. Given diagonal of square is 25 units:

  <pre> Area = 10<sup>2</sup> / 2 = 50 units<sup>2</sup> </pre>
  
4. Given perimeter of a square is 20 units:

  <pre> Area = (20 / 4)<sup>2</sup> = 25  units<sup>2</sup> </pre>
   
  
  
Find the area of a square given the perimeter:

To find the area of a square given the perimeter, simply start by dividing the given perimeter by 4. Why 4? Because a square has four (4) sides. Dividing it by 4 would give you the length of one side. Now square the known side. To square, multiply it by itself once. Once you get the result, convert it to squared units; by adding a ² to the answer.

Ex: Perimeter: 20

<pre> 20 / 4 = 5 </pre>
<pre> 5 x 5 = 25 </pre>
<pre> 25 = 25² </pre>

#### More Information:

- <a href='https://en.wikipedia.org/wiki/Square#Perimeter_and_area' target='_blank' rel='nofollow'>Wikipedia: Square</a>
- <a href='https://www.wikihow.com/Find-the-Area-of-a-Square' target='_blank' rel='nofollow'>More Illustrations</a>- 
- <a href='https://sciencing.com/area-square-using-its-perimeter-7991359.html'>more</a>-
