---
title: Area of a Triangle
---

<!-- The article goes here, in GitHub-flavored Markdown. Feel free to add YouTube videos, images, and CodePen/JSBin embeds  -->
## Area of a Triangle

A triangle is a three sided, two dimensional polygon. There are three methods to determine the area.

### Method 1
The area of a triangle can be calculated by multiplying 0.5 to the base length to the perpendicular height.

![Triangle-1](https://github.com/uuykay/misc/blob/master/area-triangle-image-2.jpg)

Mathematically this is expressed as:

![Formula-1](https://github.com/uuykay/misc/blob/master/triangle-equation-area-1.jpg)

### Method 2
If the perpendicular height is not known, you can use a different method to calculate the area. If you know the length of two sides and the size of the angle in between them, then the area can be found.

![Triangle-2](https://github.com/uuykay/misc/blob/master/area-triangle-image-3.jpg)

Mathematically this is expressed as:

![Formula-2](https://github.com/uuykay/misc/blob/master/triangle-equation-area-2.jpg)

Note that the formula expressed above uses sides a and b and angle C between them. These can be substituted for another other two sides and the angle between them.

### Method 3
If only the length of the sides are known, we can use what is known as Heron's formula to find the area.

![Triangle-3](https://github.com/uuykay/misc/blob/master/area-triangle-image-3.jpg)

Mathematically this is expressed as:

![Formula-3](https://wikimedia.org/api/rest_v1/media/math/render/svg/d138044bb9ed870dd9dc5c7c8a3c07ab1db1705d)

Where s is half the perimeter, or

![Formula-3.1](https://wikimedia.org/api/rest_v1/media/math/render/svg/08ed8a6e351198e0c4ca8d71fa2e2bc4171e9439)


### Terminology

Base - The bottom side. Select a side that is known.

Perpendicular Height - The height of the triangle, measured perpendicular to the base, to the tallest point of the triangle.

Sin - The sine trigonometric expression.

### Examples

1. Find the area of a triangle with a base length of 4 units and a perpendicular height of 12 units

   Area = 0.5 x 4 x 12 = 24 units<sup>2</sup>
   
2. If two sides of a triangle are known to be 3 and 6, and the angle between them is 30 degrees, what is the angle of the triangle?

   Area = 0.5 x 3 x 6 x sin 30° = 4.5 units<sup>2</sup>

#### More Information:
<!-- Please add any articles you think might be helpful to read before writing the article -->
- [Wikipedia: Triangle](https://en.wikipedia.org/wiki/Triangle)
- [More Examples](https://mathbits.com/MathBits/TISection/Trig/AreaTrigTri.htm)

