---
title: Area of Triangles
---

## Area of Triangles

The area of a triangle is the total enclosed space on the two-dimensional plane by the sides of the triangle.

The area of a triangle can be calculated by multiplying one half by the base * height

For example, if you have a triangle that is 3cm on the base and 4cm in height, then you can work out the area:

Area = .5 * 3 * 4 = 6cm²

#### Terminology

* Base (b) - The length of one side of the triangle (note: the side chosen for the base must always have angles of 90 degrees or less on both ends)
* Height (h) - The length of a line perpendicular with the base to the opposite point of the triangle.

#### Formula
__Area = 0.5 * base of the triangle * height of the triangle__

![Triangle](http://www.mathportal.org/calculators/plane-geometry-calculators/triangleEquilateral.gif)

For example in the image above,

Area = 0.5 * a * h

#### Important information about Obtuse Triangles

An obtuse triangle is one that has an internal angle of more than 90 degrees, like the one pictured below:

<img src="http://upload.wikimedia.org/wikipedia/commons/thumb/4/45/Obtuse_Triangle.svg/1024px-Obtuse_Triangle.svg.png" width="400">

In this case, the base must be side 'BC' and not 'AB' or 'CA' (the height would be a perpendicular line from the base to point 'A'). If the measurement of the height is not known, it would have to be measured, or it would need to be calculated using trigonometry.

### More Information

* [Area of Triangles](http://www.onlinemathlearning.com/area-triangle.html)
* [How to Calculate the Area of a Triangle](https://www.wikihow.com/Calculate-the-Area-of-a-Triangle)
