---
title: Basic Log Rules and Expanding Log Expressions
---
## Basic Log Rules and Expanding Log Expressions
<!-- The article goes here, in GitHub-flavored Markdown. Feel free to add YouTube videos, images, and CodePen/JSBin embeds  -->

The following are commonly used basic log rules:

###### Logarithm Product Rule

<span class="texhtml"> log<sub>b</sub> (x * y) = log<sub>b</sub> (x) + log<sub>b</sub> (y) </span>

###### Logarithm Quotient Rule

<span class="texhtml"> log<sub>b</sub> (x / y) = log<sub>b</sub> (x) - log<sub>b</sub> (y) </span>

###### Logarithm Power Rule</strong>

<span class="texhtml"> log<sub>b</sub> (x<sup>y</sup>) = y * log<sub>b</sub> (x) </span>

###### Logarithm of Negative Number</strong>

<span class="texhtml"> log<sub>b</sub> (x) </span> is undefined when <span class="texhtml"> x < 0 </span>

###### Logarithm of 0</strong>

<span class="texhtml"> log<sub>b</sub> (0) </span> is undefined

<span class="texhtml"> lim<sub>x &rightarrow; 0+</sub> log<sub>b</sub> (x) = -infinity </span>

###### Logarithm of 1</strong>

<span class="texhtml"> log<sub>b</sub> (1) = 0 </span>

###### Logarithm of the Base</strong>

<span class="texhtml"> log<sub>b</sub> (b) = 1 </span>

###### Logarithm of Infinity</strong>

<span class="texhtml"> lim<sub> x &rightarrow; infinity</sub> log<sub>b</sub> (x) = infinity </span>

###### Logarithm Base Switch Rule</strong>

<span class="texhtml"> log<sub>b</sub> (c) = 1 / log<sub>c</sub> (b) </span>

###### Logarithm Base Change Rule</strong>

<span class="texhtml"> log<sub>b</sub> (x) = log<sub>c</sub> (x) / log<sub>c</sub> (b) </span>

#### More Information:
<!-- Please add any articles you think might be helpful to read before writing the article -->

<a href='http://www.rapidtables.com/math/algebra/Logarithm.htm' target='_blank' rel='nofollow'>Logarithm Rules</a>

