---
title: Calculating Standard Deviation Step by Step
---
## Calculating Standard Deviation Step by Step

Standard deviation is the measure of the average distance of all data points in a set to the mean of that set. The formula for the standard deviation of any given set is:

![alt text](https://github.com/TheRealSpartacus/sources/blob/master/StdDev/SD%20form.png)

where *n* is the number of elements in the data set, *x<sub>i</sub>* is the *i*th element in the data set, and x&#772; is the mean of the data set

As seen in the formula, you first take the difference of all the values in the data set from the mean, square all of the differences, sum up all the squares, then divide it all by the number of elements in the data set minus 1.

For example if you had a data set of [1,2,3] which has a mean of 2:

You first would find the difference of all the data points and the mean:

1-2 = -1
2-2 =  0
3-2 =  1

Next you square all the differences:

(-1)^2 = 1
(0)^2 = 0
(1)^2 = 1

Then you add all the squares together:

1+0+1 = 2

Finally you divide the sum by *n*-1, giving you the standard deviation:

2/2 = 1 --> Standard Deviation.

<!-- The article goes here, in GitHub-flavored Markdown. Feel free to add YouTube videos, images, and CodePen/JSBin embeds  -->

#### More Information:
<!-- Please add any articles you think might be helpful to read before writing the article -->

<a href="http://www.youtube.com/watch?feature=player_embedded&v=HvDqbzu0i0E
" target="_blank"><img src="http://img.youtube.com/vi/HvDqbzu0i0E/0.jpg" 
alt="IMAGE ALT TEXT HERE" width="240" height="180" border="10" /></a>
