---
title: Integration Rules
---
## Integration Rules
As with differentiation, we use a variety of rules when integrating functions. Below are a few of the most common.

**The Constant Rule:**
&int;k dx = kx + C   where k is a constant

**The Power Rule:**
&int; x<sup>n</sup> dx =  + <sup>x<sup>n+1</sup></sup>&frasl;<sub>n+1</sub> + C when n &ne; 1         

**Exponential Rule:**
&int; e<sup>kx</sup> dx = <sup>1</sup>&frasl;<sub>kx</sub>  e<sup>kx</sup> + C  where k is a constant

**Trigometric Rules:**

&int; cos(x) dx = sin(x) + C

&int; sin(x) dx = -cos(x) + C

**Sum/Difference Rules:**

&int;[f(x) + g(x)]dx = &int;f(x)dx + &int;g(x)dx

&int;[f(x) - g(x)]dx = &int;f(x)dx - &int;g(x)dx

**Physical Calculus Rules:**

&int; v dt = x + C, where x is the displacement and v is the velocity

&int; a dt = v + C, where v is the velocity and a is the acceleration

a = <sup>d</sup>&frasl;<sub>dx</sub>(0.5v<sup>2</sup>) where a is the acceleration, and v is the velocity

&int; a dx = 0.5v<sup>2</sup>

a + C = 0.5v<sup>2</sup>

#### More Information:
[Basic Rules with Examples](http://archive.learnhigher.ac.uk/resources/files/Numeracy/Integration_webversion.pdf)

[In Depth Guide to Integrals](http://tutorial.math.lamar.edu/pdf/Calculus_Cheat_Sheet_Integrals.pdf)
