---
title: Circle Equations
---
## Circle Equations

![Circle centered at (x0, y0) with radius r, a point P(x, y) on the circle, and angle t](https://raw.githubusercontent.com/pranabendra/articles/master/geometry/circle/circle_2.gif)

### 1. Centre-radius form:

Circle having centre <i><b>(x<sub>0</sub>, y<sub>0</sub>)</b></i> and radius <b><i>r</i></b>.

The equation of the circle can be represented as:

![(x-x0)^2 + (y-y0)^2 = r^2](https://raw.githubusercontent.com/pranabendra/articles/master/geometry/circle/circle_3.png)

#### General Equation of a Circle:

![x^2 + y^2 + 2gx + 2fy + c = 0](https://raw.githubusercontent.com/pranabendra/articles/master/geometry/circle/circle_6.png)

where, `g`, `f`, and `c` are constants.

Therefore,

![x0 = (-g), y0 = (-f), and r = square root of (g^2 + f^2 -c)](https://raw.githubusercontent.com/pranabendra/articles/master/geometry/circle/circle_9.png)

### 2. Parametric form:

Circle having centre <i><b>(x<sub>0</sub>, y<sub>0</sub>)</b></i> and radius makes an angle <b><i>t</i></b> with the positive direction of <i>x-axis</i>, then <b><i>t</i></b> is called the `parameter`.

The equation of the circle can be represented as:

![x = x0 + rcos(t), y = y0 + rsin(t)](https://raw.githubusercontent.com/pranabendra/articles/master/geometry/circle/circle_4.png)

for, 

![0<=t<= 2 pi](https://raw.githubusercontent.com/pranabendra/articles/master/geometry/circle/circle_5.png)

### More Information:
<a href = "http://mypages.valdosta.edu/alazari/math1111/Circle.html" target="_blank" rel="nofollow">Equation of a Circle</a>


