---
title: Completing the Square
---
## Completing the Square

<!-- The article goes here, in GitHub-flavored Markdown. Feel free to add YouTube videos, images, and CodePen/JSBin embeds  -->

The completing the square method is one of the many methods for solving a <a href='https://guide.freecodecamp.org/mathematics/quadratic-equations' target='_blank'>quadratic equation</a>. It involves changing the form of the equation so that the left side becomes a perfect square.

A quadratic equation generally takes the form: <em>ax<sup>2</sup> + bx + c</em> = 0. To solve the above, follow these steps: 

1. Move the constant value to the Right Hand Side of the equation so it becomes: <br> 
<pre><em>ax<sup>2</sup> + bx = -c</em></pre>

2. Make the coefficient of x<sup>2</sup> equal to 1 by dividing both sides of the equation by <em>a</em> so that we now have: <br> 
<pre>x<sup>2</sup> + (<sup>b</sup>/<sub>a</sub>)x = -(<sup>c</sup>/<sub>a</sub>)</pre>

3. Next, add the square of half of the coefficient of the <em>x</em>-term to both sides of the equation: <br> 
<pre>x<sup>2</sup> + (<sup>b</sup>/<sub>a</sub>)x  + (<sup>b</sup>/<sub>2a</sub>)<sup>2</sup> = (<sup>b</sup>/<sub>2a</sub>)<sup>2</sup> - (<sup>c</sup>/<sub>a</sub>)</pre>

4. Completing the square on the Left Hand Side and simplifying the Right Hand Side of the above equation, we have:
<pre>(x<sup></sup> + <sup>b</sup>/<sub>2a</sub>)<sup>2</sup> = (<sup>b<sup>2</sup></sup>/<sub>4a<sup>2</sup></sub>) - (<sup>c</sup>/<sub>a</sub>)</pre>

5. Further simplifying the Right Hand Side, 
<pre>(x<sup></sup> + <sup>b</sup>/<sub>2a</sub>)<sup>2</sup> = (b<sup>2</sup> - 4ac) &divide; 4a<sup>2</sup> </pre>

6. Finding the square root of both sides of the equation, 
<pre>x<sup></sup> + <sup>b</sup>/<sub>2a</sub> = &pm;((b<sup>2</sup> - 4ac)<sup>&half;</sup> &divide; 2a) </pre>

7. By making x the subject of our formula, we are able to solve for its value completely:
<pre>x<sup></sup> = (-b &pm; (b<sup>2</sup> - 4ac)<sup>&half;</sup>) &divide; 2a </pre>

#### More Information:
<!-- Please add any articles you think might be helpful to read before writing the article -->
* [Varsity Tutors](https://www.varsitytutors.com/hotmath/hotmath_help/topics/completing-the-square)
* [Maths is Fun](https://www.mathsisfun.com/algebra/completing-square.html)

