---
title: Converting AM/PM to 24 Hour Clock
---

## Converting AM/PM to 24 Hour Clock

There are two main ways to show the time: "12-Hour Clock" or "a.m./p.m.": 24-Hour Clock.

Most countries prefer the 24-Hour Clock, yet, in Latin America and English-speaking countries the 12-Hour Clock is broadly used, where twice a day it is 12:00, at midnight and at noon. To distinguish between both, you can add a.m. or p.m. respectively.

Table below show the conversion between 12-hour clock system and 24-hour clock system.

| 12-hour clock system|24-hour clock system|
| -------------       |:-------------:     |
| 12:00 AM            | 00:00              |
| 01:00 AM            | 01:00              |
| 02:00 AM            | 02:00              |
| 03:00 AM            | 03:00              |
| 04:00 AM            | 04:00              |
| 05:00 AM            | 05:00              |
| 06:00 AM            | 06:00              |
| 07:00 AM            | 07:00              |
| 08:00 AM            | 08:00              |
| 09:00 AM            | 09:00              |
| 10:00 AM            | 10:00              |
| 11:00 AM            | 11:00              |
| 12:00 PM            | 12:00              |
| 01:00 PM            | 13:00              |
| 02:00 PM            | 14:00              |
| 03:00 PM            | 15:00              |
| 04:00 PM            | 16:00              |
| 05:00 PM            | 17:00              |
| 06:00 PM            | 18:00              |
| 07:00 PM            | 19:00              |
| 08:00 PM            | 20:00              |
| 09:00 PM            | 21:00              |
| 10:00 PM            | 22:00              |
| 11:00 PM            | 23:00              |

## 12-hour Clock (a.m./p.m.)

The day is split into 12 hours running from Midnight to Noon (a.m. hours) and 12 hours running from Noon to Midnight (p.m. hours).

The abbreviations “a.m. and p.m.” derive from Latin:

- a.m.: Ante Meridiem = Before Noon.
- p.m.: Post Meridiem = Afternoon.

## 24-hour Clock

The day runs from midnight to midnight and is divided into 24 hours, indicated by the hours passed since midnight, from 0 to 23.

## Converting AM/PM to 24 Hour Clock

### From the first hour of the day (12:00 am (Midnight) to 12:59 am), and subtract 12 hours.

- 12:00 a.m. = 0:00
- 12:15 a.m. = 0:15

### From 1:00 a.m. to 12:59 p.m., remains the same.

- 9:00 a.m. = 9:00
- 12:59 p.m. = 12:59

### From 1:00 p.m. to 11:59 p.m., add 12 hours.

- 3:17 p.m. = 15:17
- 11:59 p.m. = 23:59.

## Converting 24-hour Clock to a.m/p.m

### For the first hour of the day (0:00 to 0:59), add 12 hours and add the “a.m.” termination.

- 0:30 = 12:30 a.m.
- 0:55 = 12:55 a.m.

### From 1:00 to 11:59, just add the “a.m.” termination.

- 2:25 = 2:25 a.m.
- 9:30 = 9:30 a.m.

### From 13:00 to 23:59, subtract 12 hours, and add the “p.m.” termination.

- 16:55 = 4:55 p.m.
- 21:45 = 8:45 p.m.


#### More Information:
To read more abaout 24-hour system, you can click [Wikipedia](https://en.wikipedia.org/wiki/24-hour_clock)
