---
title: Cross Product
---
## Cross Product

In set theory, a cross product of two sets is a binary operation performed on sets, which outputs a result set.
It is denoted by the symbol X. Sometimes it is also called as Cartesian Product after mathematician Rene Descartes.
Each element of A is paired with each element of B.

<pre><code>
A X B = {(a, b) | a &isin; A and b &isin; B} 
</code></pre>

### Examples
```
let us have,
  set A = {a, b}
 & set B = {1, 2}
 then A X B = {(a, 1), (a, 2),
               (b, 1), (b, 2)}
```


### Use
  It is used to generate all possible combinations after combining two tables in a database.

### References
[Wikipedia Article](https://en.wikipedia.org/wiki/Cartesian_product)

[Wofram Alpha](https://www.wolframalpha.com/input/?i=Cartesian+product&lk=1&a=ClashPrefs_*MathWorld.CartesianProduct-)


