---
title: Definition of Factor
---
## Definition of Factor

Factors are two numbers that we can multiply together to yield another number. 
For example, 2 * 10 = 20, so 2 and 10 are factors of 20. 

Often in algebra, we want to factor out expressions.
Take, (x^2 + 4x +3), in the form Ax^2+Bx+C
in order to factor this by looking for two numbers that will multiply to equal C and add up to equal C.
3 and 4 add up to 4 and multiply to equal 3. 

With this in mind, (x^2 + 4x +3) can be factored out into (x+3)(x+1).

A factor can be defined in 2 ways. The first is in multiplication. Take _3 * 4 = 12_. Here _3_ and _4_ are factors, and together they make a product. Another way a factor can be defined is if the remainder upon division equals 0. Take the number 12. If we divide 12 by 4 
  _12 / 4 = 3_ 
The remainder is 0. There are no decimal spaces, and therefore 4 is _a factor of_ 12. Likewise, if we do
  _12 / 3 = 4_
we also get a remainder of 0. Therefore both 3 and 4 are factors of 12.

We can simplify this and use _%_ as the modulo function. This will give us
  _12 % 3 = 0_
Because the modulo function returns the remainder upon division, any number that returns 0 upon the use of modulo is a factor of the other number. 

#### More Information:
[Here's a link](https://www.khanacademy.org/math/pre-algebra/pre-algebra-factors-multiples/pre-algebra-factors-mult/v/finding-factors-of-a-number) to a quick video explaining factoring numbers
Learn more about factoring out expressions [here](https://www.khanacademy.org/math/pre-algebra/pre-algebra-factors-multiples/pre-algebra-factors-mult/v/finding-factors-and-multiples)
