---
title: Definition of Mode
---
## Definition of Mode

In statistics, the term _mode_ refers to the value or values in a set of data that appears the most frequently. Because it occurs most often in the data set, the _mode_ is the most likely value to be randomly sampled.

The mode of a set of numbers indicates the value which occurs most frequently in the set.
Given a distribution of data, the mode can be described as the maximum of either the probability mass function if the data are discrete, or the probability distribution function if the data are continuous.

#### A set of data can have one or more modes

Consider the data set 14, 16, 21, 33, 37, 16, 39, 33 Here 16 and 33 each occurs twice. All other numbers occur one time only. So 16 and 33 have the maximum frequency of occurrence which is 2. Hence, there are two modes for given data set, i.e., 16 and 33. A set of number in which there are two numbers which occur most frequently may be described as bimodal, and any number greater than two is said to be multimodal.

#### It is also possible to have a set of data with no mode

Consider the data set 10, 15, 24, 34, 38, 16, 41. Here all numbers occur one time only. So no one number has the maximum frequency of occurrence. Hence, there is no mode for this given data set.

## Rules to find the mode of a data set
  * Examine all the numbers of the data set and find if one or more numbers are occurring more than once.
  * The number with the maximum frequency of occurrence is the mode.
  * If more than one number has a maximum frequency, then there is more than one mode for the data set.
  * If all the numbers of data set occur only one time, then there is no mode for the data set.  

#### Example

The mode of ( 1, 2, 3, 2, 4, 5 ) is **2**:

_To find the mode you must count the number of occurrences of each value in the data set. The value 2 appears twice in the data set, and the rest of the values occur only once, which makes 2 th mode._

The mode of ( 7, 7, 8, 8, 9 ) is 7 **and** 8:

_If there is a tie for the values that occur most frequently in the data set, the mode is each of the values with this frequency._

#### Mean and Median
Mode is often confused with [mean](https://guide.freecodecamp.org/mathematics/definition-of-mean), the average value in the data set
[median](https://en.wikipedia.org/wiki/Median), the value in the middle of the data set.

#### More Information:
[Wikipedia - Mode](https://en.wikipedia.org/wiki/Mode_(statistics))

[Mode Definition](https://www.tutorialspoint.com/mean_median_and_mode/mode_of_data_set.htm)
