---
title: Dividing Fractions
---
## Dividing Fractions

This is similar to multiplying two fractions, with an additional step

Consider the expression A &divide; B, here A is called the <i>dividend</i> and B is called the <i>divisor</i>.

Here are the steps to divide two fractions,

1. Take the reciprocal of the divisor fraction (B). 
2. Multiply the dividend fraction (A) with the reciprocal of the divisor fraction
3. Simplify the resultant fraction, if possible

#### Examples

##### Example 1

<pre>  <span class="fraction"><sup>2</sup>⁄<sub>3</sub></span> &divide; <span class="fraction"><sup>6</sup>⁄<sub>7</sub></span> </pre>

1. Take the reciprocal of the divisor. To take a reciprocal of a fraction, interchange the numerator and denominator of that fraction. The reciprocal of <span class="fraction"><sup>6</sup>⁄<sub>7</sub></span> is <span class="fraction"><sup>7</sup>⁄<sub>6</sub></span>

2. Multiply the dividend with the reciprocal of the divisor

<pre> <span class="fraction"><sup>2</sup>⁄<sub>3</sub></span> &divide; <span class="fraction"><sup>6</sup>⁄<sub>7</sub></span> = <span class="fraction"><sup>2</sup>⁄<sub>3</sub></span> &times; <span class="fraction"><sup>7</sup>⁄<sub>6</sub></span> = <span class="fraction"><sup>7</sup>⁄<sub>9</sub></span> </pre>

##### Example 2

<pre>  <span class="fraction"><sup>4</sup>⁄<sub>6</sub></span> &divide; 2 </span> = <span class="fraction"><sup>4</sup>⁄<sub>6</sub></span> &times <span class="fraction"><sup>1</sup>⁄<sub>2</sub></span> = <span class="fraction"><sup>4</sup>⁄<sub>12</sub></span> = <span class="fraction"><sup>1</sup>⁄<sub>3</sub></span> (Simplified) </pre>

Please note a whole number can be considered as a fraction by considering its denominator as 1.
<br>Also, you can only divide by non-zero fractions.
