---
title: Equation of Tangent Line
---
## Equation of Tangent Line

A tangent line to a function f(x) is a straight line that passes through the point (x<sub>0</sub>, f(x<sub>0</sub>)) and has slope f'(x<sub>0</sub>). The slope of the tangent line represents the instantaneous rate of change of the function at that point.

### Finding the equation of a tangent line:

To find the equation of a tangent line,

<p align='center'>
  y = mx + b,
</p>

of a function f(x) at point x = x<sub>0</sub>, we need to do the following:

1. Find the derivative of the function.
2. Find the value of the derivative at x = x<sub>0</sub>, this will be the slope of the tangent (our m above).
3. Find the value y<sub>0</sub> of the function at x<sub>0</sub>. The tangent will pass through the point (x<sub>0</sub>, y<sub>0</sub>).
4. Find the equation of the tangent using point-slope form. As the tangent passes through (x<sub>0</sub>, y<sub>0</sub>) and has slope m, the equation of the tangent line can be written as (y - y<sub>0</sub>) = m(x - x<sub>0</sub>) or y = mx + (y<sub>0</sub> - mx<sub>0</sub>).

#### Example

Find the equation of tangent line to the function f(x) = 4x<sup>2</sup> - 4x + 1 at x = 2.

We proceed through the steps above.

Step 1 : f'(x) = 8x - 4.

Step 2 : m = f'(2) = 8 &middot; 2 - 4 = 12.

Step 3 : y<sub>0</sub> = f(x<sub>0</sub>) = f(2) = 4 &middot; 2<sup>2</sup> - 4 &middot; 2 + 1 = 16 - 8 + 1 = 9.

Step 4 : From steps 2 and 3 we have m = 12 and (x<sub>0</sub>, y<sub>0</sub>) = (2,9), so the equation of the tangent line is 

<p alig='center'>
  (y - 9) = 12(x - 2)
</p>

or, rearranging to slope intercept form,

<p align='center'>
  y = 12x - 15.
</p>
