---
title: Example of Subtracting Fractions with Unlike Denominators
---
## Example of Subtracting Fractions with Unlike Denominators

Subtracting fractions with unlike denominators is similar to addition of fractions with unlike denominators. Here are the steps,

1. Convert the fractions to equivalent fractions with common denominator
2. To convert two fractions to common denominator, multiply the numerator and denominator of a fraction with the denominator of the other fraction.
3. Now that the fractions have common denominators, subtract the numerators of both fractions and put the resultant over the denominator

   Consider, <span class="fraction"><sup>a</sup>⁄<sub>b</sub></span> and <span class="fraction"><sup>c</sup>⁄<sub>d</sub></span>  are fractions with different denominators, you can subtract these fractions in a single step like below,
<br>
<pre>  <span class="fraction"><sup>a</sup>⁄<sub>b</sub></span> - <span class="fraction"><sup>c</sup>⁄<sub>d</sub></span> = <span class="fraction"><sup>(a * d) - (b * c)</sup>⁄<sub>(b * d)</sub></span> </pre>

###### Example

Consider fractions <span class="fraction"><sup>5</sup>⁄<sub>6</sub></span> and <span class="fraction"><sup>5</sup>⁄<sub>15</sub></span>

1. The denominators are different. So you need to make the denominators common
2. Before that, if possible, simplify the fractions. In this case, <span class="fraction"><sup>5</sup>⁄<sub>15</sub></span> can be simplified as <span class="fraction"><sup>1</sup>⁄<sub>3</sub></span>. Here <span class="fraction"><sup>5</sup>⁄<sub>15</sub></span> and <span class="fraction"><sup>1</sup>⁄<sub>3</sub></span> are called equivalent fractions.
3. After simplification, the fractions are <span class="fraction"><sup>5</sup>⁄<sub>6</sub></span> and <span class="fraction"><sup>1</sup>⁄<sub>3</sub></span>.
4. Now to subtract these fractions, you must make the denominators common
5. Multiply the numerator and denominator of a fraction with denominator of the other
6. For fraction <span class="fraction"><sup>5</sup>⁄<sub>6</sub></span> , the denominator of the other fraction is 3. For fraction <span class="fraction"><sup>1</sup>⁄<sub>3</sub></span> , the denominator of the other fraction is 6

<pre>  <span class="fraction"><sup>((5 * 3) - (1 * 6))</sup>⁄<sub>(6 * 3)</sub></span> = <span class="fraction"><sup>9</sup>⁄<sub>18</sub></span> </pre>

7. The resultant fraction is <span class="fraction"><sup>9</sup>⁄<sub>18</sub></span>. This can be further simplified as <span class="fraction"><sup>1</sup>⁄<sub>2</sub></span>

<pre>  <span class="fraction"><sup>5</sup>⁄<sub>6</sub></span> - <span class="fraction"><sup>5</sup>⁄<sub>15</sub></span> = <span class="fraction"><sup>1</sup>⁄<sub>2</sub></span> </pre>


