---
title: Exponents
---
## Exponents                                                           

An exponent is shorthand for the number of times a number is multipled by itself.  It is typically denoted with a superscript, karat, or with "to the power of" such as:

- 2<sup>3</sup>
- 2^3
- 2 to the power of 3

In this example, 3 is the exponent. 

To compute the value of 2<sup>3</sup>, you would multiply 2 to itself 3 times: 2 * 2 * 2.  This evaluates to 8.

The general format of writing an exponent is:  
- base<sup># of times you multiply base by itself</sup>

Common exponents have special names:
- An exponent of 2 means the number is squared.  So 3<sup>2</sup> is referred to as 3 squared, evaluating to 9.
- An exponent of 3 means the number is cubed.  So 2<sup>3</sup> is referred to as 2 cubed, evaluating to 8.

### Negative Exponents
Negative exponents are computed similarly, except the value is placed as a denominator beneath a numerator of 1.

For example, 2<sup>-2</sup> = <sup>1</sup>/<sub>(2 * 2)</sub> = <sup>1</sup>/<sub>4</sub>

### More Examples 
2<sup>5</sup> = 2 * 2 * 2 * 2 * 2 = 32

(-2)<sup>5</sup> = -2 * -2 * -2 * -2 * -2 = -32

10<sup>6</sup> = 1,000,000

2<sup>-5</sup> = <sup>1</sup>/<sub>(2 * 2 * 2 * 2 * 2)</sub> = <sup>1</sup>/<sub>32</sub>

### More Information:

- [Wikipedia](https://en.wikipedia.org/wiki/Exponentiation)
